rule win_mirage_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mirage."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mirage"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c745f804010000 ff75fc ff15???????? ff75fc }
            // n = 4, score = 200
            //   c745f804010000       | mov                 dword ptr [ebp - 8], 0x104
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_1 = { 59 3bc3 59 7412 83c005 50 8d85ecfeffff }
            // n = 7, score = 200
            //   59                   | pop                 ecx
            //   3bc3                 | cmp                 eax, ebx
            //   59                   | pop                 ecx
            //   7412                 | je                  0x14
            //   83c005               | add                 eax, 5
            //   50                   | push                eax
            //   8d85ecfeffff         | lea                 eax, [ebp - 0x114]

        $sequence_2 = { 83c428 8935???????? b001 5f 5e 5b }
            // n = 6, score = 200
            //   83c428               | add                 esp, 0x28
            //   8935????????         |                     
            //   b001                 | mov                 al, 1
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_3 = { 8d45f4 50 53 68???????? c745f804010000 ff75fc }
            // n = 6, score = 200
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   68????????           |                     
            //   c745f804010000       | mov                 dword ptr [ebp - 8], 0x104
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_4 = { be14410000 8d85d4beffff 56 53 50 e8???????? }
            // n = 6, score = 200
            //   be14410000           | mov                 esi, 0x4114
            //   8d85d4beffff         | lea                 eax, [ebp - 0x412c]
            //   56                   | push                esi
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_5 = { 7407 68f4010000 eb06 ff35???????? ff15???????? }
            // n = 5, score = 200
            //   7407                 | je                  9
            //   68f4010000           | push                0x1f4
            //   eb06                 | jmp                 8
            //   ff35????????         |                     
            //   ff15????????         |                     

        $sequence_6 = { e8???????? 83c41c 8935???????? 8ac3 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   8935????????         |                     
            //   8ac3                 | mov                 al, bl

        $sequence_7 = { ff75fc ff15???????? 8b8514010000 2b7df4 8985e0bfffff 8d450d }
            // n = 6, score = 200
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   8b8514010000         | mov                 eax, dword ptr [ebp + 0x114]
            //   2b7df4               | sub                 edi, dword ptr [ebp - 0xc]
            //   8985e0bfffff         | mov                 dword ptr [ebp - 0x4020], eax
            //   8d450d               | lea                 eax, [ebp + 0xd]

        $sequence_8 = { 8d8520010000 56 50 e8???????? 8b4510 }
            // n = 5, score = 200
            //   8d8520010000         | lea                 eax, [ebp + 0x120]
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_9 = { 6801000080 ff15???????? 85c0 7556 }
            // n = 4, score = 200
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7556                 | jne                 0x58

        $sequence_10 = { 889590fcffff 33db f3ab 66ab 8d8d90feffff 895dfc }
            // n = 6, score = 200
            //   889590fcffff         | mov                 byte ptr [ebp - 0x370], dl
            //   33db                 | xor                 ebx, ebx
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   8d8d90feffff         | lea                 ecx, [ebp - 0x170]
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx

        $sequence_11 = { 755d 8b06 385d08 8b08 }
            // n = 4, score = 100
            //   755d                 | jne                 0x5f
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   385d08               | cmp                 byte ptr [ebp + 8], bl
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_12 = { 83c414 8d8530fbffff 53 50 e8???????? 59 50 }
            // n = 7, score = 100
            //   83c414               | add                 esp, 0x14
            //   8d8530fbffff         | lea                 eax, [ebp - 0x4d0]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   50                   | push                eax

        $sequence_13 = { 50 ff15???????? 8d4d9c 885dfc e8???????? }
            // n = 5, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d4d9c               | lea                 ecx, [ebp - 0x64]
            //   885dfc               | mov                 byte ptr [ebp - 4], bl
            //   e8????????           |                     

        $sequence_14 = { 894518 e8???????? 8bf8 59 85ff 7504 33c0 }
            // n = 7, score = 100
            //   894518               | mov                 dword ptr [ebp + 0x18], eax
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   59                   | pop                 ecx
            //   85ff                 | test                edi, edi
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax

        $sequence_15 = { 7405 83f847 7517 8d860c010000 }
            // n = 4, score = 100
            //   7405                 | je                  7
            //   83f847               | cmp                 eax, 0x47
            //   7517                 | jne                 0x19
            //   8d860c010000         | lea                 eax, [esi + 0x10c]

    condition:
        7 of them and filesize < 1695744
}