rule win_misha_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.misha."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.misha"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? ff7508 8d45e8 50 e8???????? 83c414 eb02 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   eb02                 | jmp                 4

        $sequence_1 = { 8b45b8 8945c0 8b45b8 8945c8 c645df01 eb04 c645df01 }
            // n = 7, score = 300
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax
            //   c645df01             | mov                 byte ptr [ebp - 0x21], 1
            //   eb04                 | jmp                 6
            //   c645df01             | mov                 byte ptr [ebp - 0x21], 1

        $sequence_2 = { eb04 8b542410 0fb64c240c 8bc1 4a 48 7422 }
            // n = 7, score = 300
            //   eb04                 | jmp                 6
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   0fb64c240c           | movzx               ecx, byte ptr [esp + 0xc]
            //   8bc1                 | mov                 eax, ecx
            //   4a                   | dec                 edx
            //   48                   | dec                 eax
            //   7422                 | je                  0x24

        $sequence_3 = { a5 a5 8b450c c780f800000004000000 8b450c c780f400000001000000 }
            // n = 6, score = 300
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   c780f800000004000000     | mov    dword ptr [eax + 0xf8], 4
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   c780f400000001000000     | mov    dword ptr [eax + 0xf4], 1

        $sequence_4 = { c3 55 8bec 81ec10020000 ff750c }
            // n = 5, score = 300
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec10020000         | sub                 esp, 0x210
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_5 = { eb43 837d1400 7421 ff7518 ff7514 ff7510 }
            // n = 6, score = 300
            //   eb43                 | jmp                 0x45
            //   837d1400             | cmp                 dword ptr [ebp + 0x14], 0
            //   7421                 | je                  0x23
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   ff7510               | push                dword ptr [ebp + 0x10]

        $sequence_6 = { 397d0c 7456 57 57 ff750c ff7508 }
            // n = 6, score = 300
            //   397d0c               | cmp                 dword ptr [ebp + 0xc], edi
            //   7456                 | je                  0x58
            //   57                   | push                edi
            //   57                   | push                edi
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_7 = { 2b4508 f7d8 48 e9???????? 837d1800 7419 }
            // n = 6, score = 300
            //   2b4508               | sub                 eax, dword ptr [ebp + 8]
            //   f7d8                 | neg                 eax
            //   48                   | dec                 eax
            //   e9????????           |                     
            //   837d1800             | cmp                 dword ptr [ebp + 0x18], 0
            //   7419                 | je                  0x1b

        $sequence_8 = { c78550feffff18181818 c78554feffff18181818 c78558feffff18181819 c7855cfeffff19191919 c78560feffff19191919 c78564feffff19191919 c78568feffff19191919 }
            // n = 7, score = 300
            //   c78550feffff18181818     | mov    dword ptr [ebp - 0x1b0], 0x18181818
            //   c78554feffff18181818     | mov    dword ptr [ebp - 0x1ac], 0x18181818
            //   c78558feffff18181819     | mov    dword ptr [ebp - 0x1a8], 0x19181818
            //   c7855cfeffff19191919     | mov    dword ptr [ebp - 0x1a4], 0x19191919
            //   c78560feffff19191919     | mov    dword ptr [ebp - 0x1a0], 0x19191919
            //   c78564feffff19191919     | mov    dword ptr [ebp - 0x19c], 0x19191919
            //   c78568feffff19191919     | mov    dword ptr [ebp - 0x198], 0x19191919

        $sequence_9 = { ff75dc 6a08 59 e8???????? 83c420 0fb6c0 85c0 }
            // n = 7, score = 300
            //   ff75dc               | push                dword ptr [ebp - 0x24]
            //   6a08                 | push                8
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   83c420               | add                 esp, 0x20
            //   0fb6c0               | movzx               eax, al
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 710656
}