rule win_molerat_loader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.molerat_loader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.molerat_loader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89480c 894808 c3 6a14 e8???????? 59 85c0 }
            // n = 7, score = 100
            //   89480c               | mov                 dword ptr [eax + 0xc], ecx
            //   894808               | mov                 dword ptr [eax + 8], ecx
            //   c3                   | ret                 
            //   6a14                 | push                0x14
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax

        $sequence_1 = { 668b4d08 663b8800b64300 740c 40 40 }
            // n = 5, score = 100
            //   668b4d08             | mov                 cx, word ptr [ebp + 8]
            //   663b8800b64300       | cmp                 cx, word ptr [eax + 0x43b600]
            //   740c                 | je                  0xe
            //   40                   | inc                 eax
            //   40                   | inc                 eax

        $sequence_2 = { 83c40c 32c0 e9???????? 8d55d4 52 68???????? 50 }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   32c0                 | xor                 al, al
            //   e9????????           |                     
            //   8d55d4               | lea                 edx, [ebp - 0x2c]
            //   52                   | push                edx
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_3 = { 59 59 80cb01 8bc6 c1f805 8d0c8520924400 8bc6 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   80cb01               | or                  bl, 1
            //   8bc6                 | mov                 eax, esi
            //   c1f805               | sar                 eax, 5
            //   8d0c8520924400       | lea                 ecx, [eax*4 + 0x449220]
            //   8bc6                 | mov                 eax, esi

        $sequence_4 = { 50 8b4204 ffd0 c745fcffffffff 8b85e4070000 83c0f0 8d480c }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   ffd0                 | call                eax
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8b85e4070000         | mov                 eax, dword ptr [ebp + 0x7e4]
            //   83c0f0               | add                 eax, -0x10
            //   8d480c               | lea                 ecx, [eax + 0xc]

        $sequence_5 = { 8d55ec 68???????? 52 c645fc0d e8???????? }
            // n = 5, score = 100
            //   8d55ec               | lea                 edx, [ebp - 0x14]
            //   68????????           |                     
            //   52                   | push                edx
            //   c645fc0d             | mov                 byte ptr [ebp - 4], 0xd
            //   e8????????           |                     

        $sequence_6 = { c645fc07 e8???????? 83c40c 885dfc e8???????? }
            // n = 5, score = 100
            //   c645fc07             | mov                 byte ptr [ebp - 4], 7
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   885dfc               | mov                 byte ptr [ebp - 4], bl
            //   e8????????           |                     

        $sequence_7 = { 68000000a0 8d55ec 52 8bce e8???????? 6a00 6a00 }
            // n = 7, score = 100
            //   68000000a0           | push                0xa0000000
            //   8d55ec               | lea                 edx, [ebp - 0x14]
            //   52                   | push                edx
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_8 = { e8???????? ff45c0 8b5dd8 47 e9???????? }
            // n = 5, score = 100
            //   e8????????           |                     
            //   ff45c0               | inc                 dword ptr [ebp - 0x40]
            //   8b5dd8               | mov                 ebx, dword ptr [ebp - 0x28]
            //   47                   | inc                 edi
            //   e9????????           |                     

        $sequence_9 = { e8???????? 83c40c 83bd74ffffff00 7f05 e8???????? 8b9d70ffffff e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   83bd74ffffff00       | cmp                 dword ptr [ebp - 0x8c], 0
            //   7f05                 | jg                  7
            //   e8????????           |                     
            //   8b9d70ffffff         | mov                 ebx, dword ptr [ebp - 0x90]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 688128
}