rule win_mosquito_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mosquito."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mosquito"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f3a5 ff942464020000 81c450020000 85c0 }
            // n = 4, score = 400
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   ff942464020000       | call                dword ptr [esp + 0x264]
            //   81c450020000         | add                 esp, 0x250
            //   85c0                 | test                eax, eax

        $sequence_1 = { 52 50 6a00 6801c1fd7d }
            // n = 4, score = 400
            //   52                   | push                edx
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6801c1fd7d           | push                0x7dfdc101

        $sequence_2 = { f7d8 1bc0 83e0b4 83c04c }
            // n = 4, score = 400
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   83e0b4               | and                 eax, 0xffffffb4
            //   83c04c               | add                 eax, 0x4c

        $sequence_3 = { 8b10 8bc8 56 53 ff5204 e8???????? 57 }
            // n = 7, score = 300
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8bc8                 | mov                 ecx, eax
            //   56                   | push                esi
            //   53                   | push                ebx
            //   ff5204               | call                dword ptr [edx + 4]
            //   e8????????           |                     
            //   57                   | push                edi

        $sequence_4 = { 8b00 33ff 57 6880000000 6a03 57 6a01 }
            // n = 7, score = 300
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   33ff                 | xor                 edi, edi
            //   57                   | push                edi
            //   6880000000           | push                0x80
            //   6a03                 | push                3
            //   57                   | push                edi
            //   6a01                 | push                1

        $sequence_5 = { b9cb410000 f7f9 6a20 69c27b6d0100 }
            // n = 4, score = 300
            //   b9cb410000           | mov                 ecx, 0x41cb
            //   f7f9                 | idiv                ecx
            //   6a20                 | push                0x20
            //   69c27b6d0100         | imul                eax, edx, 0x16d7b

        $sequence_6 = { 8b10 8bc8 57 6842730000 }
            // n = 4, score = 300
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8bc8                 | mov                 ecx, eax
            //   57                   | push                edi
            //   6842730000           | push                0x7342

        $sequence_7 = { 897702 e8???????? 8b45fc 83c410 897842 5f }
            // n = 6, score = 300
            //   897702               | mov                 dword ptr [edi + 2], esi
            //   e8????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c410               | add                 esp, 0x10
            //   897842               | mov                 dword ptr [eax + 0x42], edi
            //   5f                   | pop                 edi

        $sequence_8 = { e8???????? 6a20 8bf0 e8???????? 8bc8 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   6a20                 | push                0x20
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax

        $sequence_9 = { 8bfc f3a5 ff942460020000 81c450020000 }
            // n = 4, score = 300
            //   8bfc                 | mov                 edi, esp
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   ff942460020000       | call                dword ptr [esp + 0x260]
            //   81c450020000         | add                 esp, 0x250

        $sequence_10 = { 0000 0001 1001 c550f0 8b8078005900 }
            // n = 5, score = 200
            //   0000                 | add                 byte ptr [eax], al
            //   0001                 | add                 byte ptr [ecx], al
            //   1001                 | adc                 byte ptr [ecx], al
            //   c550f0               | lds                 edx, ptr [eax - 0x10]
            //   8b8078005900         | mov                 eax, dword ptr [eax + 0x590078]

        $sequence_11 = { ff15???????? 6a00 56 ff15???????? 8903 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8903                 | mov                 dword ptr [ebx], eax

        $sequence_12 = { 0000 006301 1000 7500 }
            // n = 4, score = 200
            //   0000                 | add                 byte ptr [eax], al
            //   006301               | add                 byte ptr [ebx + 1], ah
            //   1000                 | adc                 byte ptr [eax], al
            //   7500                 | jne                 2

        $sequence_13 = { 0000 00645657 8b7dc2 0400 }
            // n = 4, score = 200
            //   0000                 | add                 byte ptr [eax], al
            //   00645657             | add                 byte ptr [esi + edx*2 + 0x57], ah
            //   8b7dc2               | mov                 edi, dword ptr [ebp - 0x3e]
            //   0400                 | add                 al, 0

        $sequence_14 = { 0000 0032 08804d086440 5e }
            // n = 4, score = 200
            //   0000                 | add                 byte ptr [eax], al
            //   0032                 | add                 byte ptr [edx], dh
            //   08804d086440         | or                  byte ptr [eax + 0x4064084d], al
            //   5e                   | pop                 esi

        $sequence_15 = { e8???????? 6a20 8bd8 e8???????? 8bc8 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   6a20                 | push                0x20
            //   8bd8                 | mov                 ebx, eax
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax

        $sequence_16 = { 0000 006500 676c 0010 }
            // n = 4, score = 200
            //   0000                 | add                 byte ptr [eax], al
            //   006500               | add                 byte ptr [ebp], ah
            //   676c                 | insb                byte ptr es:[di], dx
            //   0010                 | add                 byte ptr [eax], dl

        $sequence_17 = { 0000 00748078 3001 40 }
            // n = 4, score = 200
            //   0000                 | add                 byte ptr [eax], al
            //   00748078             | add                 byte ptr [eax + eax*4 + 0x78], dh
            //   3001                 | xor                 byte ptr [ecx], al
            //   40                   | inc                 eax

        $sequence_18 = { 0000 0018 a0???????? 57 }
            // n = 4, score = 200
            //   0000                 | add                 byte ptr [eax], al
            //   0018                 | add                 byte ptr [eax], bl
            //   a0????????           |                     
            //   57                   | push                edi

        $sequence_19 = { e8???????? 83c40c e8???????? 6a20 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   e8????????           |                     
            //   6a20                 | push                0x20

        $sequence_20 = { 6f 00e8 108d8b060400 8b4589 45 8b54000b 0002 }
            // n = 7, score = 200
            //   6f                   | outsd               dx, dword ptr [esi]
            //   00e8                 | add                 al, ch
            //   108d8b060400         | adc                 byte ptr [ebp + 0x4068b], cl
            //   8b4589               | mov                 eax, dword ptr [ebp - 0x77]
            //   45                   | inc                 ebp
            //   8b54000b             | mov                 edx, dword ptr [eax + eax + 0xb]
            //   0002                 | add                 byte ptr [edx], al

    condition:
        7 of them and filesize < 1015808
}