rule win_mozart_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mozart."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mozart"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c705????????01000000 c705????????04000000 890d???????? 890d???????? 890d???????? ff15???????? }
            // n = 6, score = 200
            //   c705????????01000000     |     
            //   c705????????04000000     |     
            //   890d????????         |                     
            //   890d????????         |                     
            //   890d????????         |                     
            //   ff15????????         |                     

        $sequence_1 = { 33f6 c644241800 eb39 80fb3d }
            // n = 4, score = 200
            //   33f6                 | xor                 esi, esi
            //   c644241800           | mov                 byte ptr [esp + 0x18], 0
            //   eb39                 | jmp                 0x3b
            //   80fb3d               | cmp                 bl, 0x3d

        $sequence_2 = { e8???????? 81c404040000 c3 55 e8???????? 8b8c2414040000 83c404 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   81c404040000         | add                 esp, 0x404
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   e8????????           |                     
            //   8b8c2414040000       | mov                 ecx, dword ptr [esp + 0x414]
            //   83c404               | add                 esp, 4

        $sequence_3 = { c6042900 8b4c244c 5d b801000000 5b e8???????? }
            // n = 6, score = 200
            //   c6042900             | mov                 byte ptr [ecx + ebp], 0
            //   8b4c244c             | mov                 ecx, dword ptr [esp + 0x4c]
            //   5d                   | pop                 ebp
            //   b801000000           | mov                 eax, 1
            //   5b                   | pop                 ebx
            //   e8????????           |                     

        $sequence_4 = { 51 53 b8???????? 56 33d2 }
            // n = 5, score = 200
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   b8????????           |                     
            //   56                   | push                esi
            //   33d2                 | xor                 edx, edx

        $sequence_5 = { 880429 41 83c603 8d46ff }
            // n = 4, score = 200
            //   880429               | mov                 byte ptr [ecx + ebp], al
            //   41                   | inc                 ecx
            //   83c603               | add                 esi, 3
            //   8d46ff               | lea                 eax, [esi - 1]

        $sequence_6 = { 8b8c2450010000 83c40c e8???????? 5f }
            // n = 4, score = 200
            //   8b8c2450010000       | mov                 ecx, dword ptr [esp + 0x150]
            //   83c40c               | add                 esp, 0xc
            //   e8????????           |                     
            //   5f                   | pop                 edi

        $sequence_7 = { c605????????76 c605????????2e a2???????? c605????????78 a2???????? c605????????00 }
            // n = 6, score = 200
            //   c605????????76       |                     
            //   c605????????2e       |                     
            //   a2????????           |                     
            //   c605????????78       |                     
            //   a2????????           |                     
            //   c605????????00       |                     

        $sequence_8 = { 83fe10 7409 33f6 c644241800 eb39 80fb3d 740e }
            // n = 7, score = 200
            //   83fe10               | cmp                 esi, 0x10
            //   7409                 | je                  0xb
            //   33f6                 | xor                 esi, esi
            //   c644241800           | mov                 byte ptr [esp + 0x18], 0
            //   eb39                 | jmp                 0x3b
            //   80fb3d               | cmp                 bl, 0x3d
            //   740e                 | je                  0x10

        $sequence_9 = { 5f 5e 5d 5b 8bc2 f7d8 }
            // n = 6, score = 200
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   8bc2                 | mov                 eax, edx
            //   f7d8                 | neg                 eax

    condition:
        7 of them and filesize < 114688
}