rule win_mqsttang_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mqsttang."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mqsttang"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd0 ebd0 c744241c02000000 c744242000000000 c744242400000000 c744242800000000 c744242cb47e7b00 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   ebd0                 | jmp                 0xffffffd2
            //   c744241c02000000     | mov                 dword ptr [esp + 0x1c], 2
            //   c744242000000000     | mov                 dword ptr [esp + 0x20], 0
            //   c744242400000000     | mov                 dword ptr [esp + 0x24], 0
            //   c744242800000000     | mov                 dword ptr [esp + 0x28], 0
            //   c744242cb47e7b00     | mov                 dword ptr [esp + 0x2c], 0x7b7eb4

        $sequence_1 = { e8???????? 8b4da8 e8???????? 8b4dac e8???????? 891c24 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4da8               | mov                 ecx, dword ptr [ebp - 0x58]
            //   e8????????           |                     
            //   8b4dac               | mov                 ecx, dword ptr [ebp - 0x54]
            //   e8????????           |                     
            //   891c24               | mov                 dword ptr [esp], ebx
            //   e8????????           |                     

        $sequence_2 = { e8???????? 8b85d0bfffff 8b00 3b5804 7ed8 8b85f0bfffff 3b85c0bfffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b85d0bfffff         | mov                 eax, dword ptr [ebp - 0x4030]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   3b5804               | cmp                 ebx, dword ptr [eax + 4]
            //   7ed8                 | jle                 0xffffffda
            //   8b85f0bfffff         | mov                 eax, dword ptr [ebp - 0x4010]
            //   3b85c0bfffff         | cmp                 eax, dword ptr [ebp - 0x4040]

        $sequence_3 = { f20f106dd0 f20f1055d8 f20f115d90 f20f116588 f20f116d80 f20f119578ffffff b808000000 }
            // n = 7, score = 100
            //   f20f106dd0           | movsd               xmm5, qword ptr [ebp - 0x30]
            //   f20f1055d8           | movsd               xmm2, qword ptr [ebp - 0x28]
            //   f20f115d90           | movsd               qword ptr [ebp - 0x70], xmm3
            //   f20f116588           | movsd               qword ptr [ebp - 0x78], xmm4
            //   f20f116d80           | movsd               qword ptr [ebp - 0x80], xmm5
            //   f20f119578ffffff     | movsd               qword ptr [ebp - 0x88], xmm2
            //   b808000000           | mov                 eax, 8

        $sequence_4 = { e8???????? 8b4340 8b4004 85c0 7507 8b4354 85c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4340               | mov                 eax, dword ptr [ebx + 0x40]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   8b4354               | mov                 eax, dword ptr [ebx + 0x54]
            //   85c0                 | test                eax, eax

        $sequence_5 = { e8???????? 85c0 0f844cffffff c705????????20339000 c705????????ffffffff c70424???????? e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f844cffffff         | je                  0xffffff52
            //   c705????????20339000     |     
            //   c705????????ffffffff     |     
            //   c70424????????       |                     
            //   e8????????           |                     

        $sequence_6 = { e9???????? 8b06 ba20000000 8b9ecc000000 8945c0 8b45c4 668b4002 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   ba20000000           | mov                 edx, 0x20
            //   8b9ecc000000         | mov                 ebx, dword ptr [esi + 0xcc]
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax
            //   8b45c4               | mov                 eax, dword ptr [ebp - 0x3c]
            //   668b4002             | mov                 ax, word ptr [eax + 2]

        $sequence_7 = { f7e7 8d04b6 01c1 c1ea02 01ca 8b0493 5b }
            // n = 7, score = 100
            //   f7e7                 | mul                 edi
            //   8d04b6               | lea                 eax, [esi + esi*4]
            //   01c1                 | add                 ecx, eax
            //   c1ea02               | shr                 edx, 2
            //   01ca                 | add                 edx, ecx
            //   8b0493               | mov                 eax, dword ptr [ebx + edx*4]
            //   5b                   | pop                 ebx

        $sequence_8 = { eb96 89c6 8d5db4 eb97 89c6 8d5db4 eb98 }
            // n = 7, score = 100
            //   eb96                 | jmp                 0xffffff98
            //   89c6                 | mov                 esi, eax
            //   8d5db4               | lea                 ebx, [ebp - 0x4c]
            //   eb97                 | jmp                 0xffffff99
            //   89c6                 | mov                 esi, eax
            //   8d5db4               | lea                 ebx, [ebp - 0x4c]
            //   eb98                 | jmp                 0xffffff9a

        $sequence_9 = { e8???????? 891c24 89c1 a3???????? e8???????? 83ec04 83c418 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   891c24               | mov                 dword ptr [esp], ebx
            //   89c1                 | mov                 ecx, eax
            //   a3????????           |                     
            //   e8????????           |                     
            //   83ec04               | sub                 esp, 4
            //   83c418               | add                 esp, 0x18

    condition:
        7 of them and filesize < 12651520
}