rule win_mystic_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mystic_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mystic_stealer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8986bc160000 8bc1 668986b8160000 e9???????? 0fb786c40a0000 }
            // n = 5, score = 300
            //   8986bc160000         | mov                 dword ptr [esi + 0x16bc], eax
            //   8bc1                 | mov                 eax, ecx
            //   668986b8160000       | mov                 word ptr [esi + 0x16b8], ax
            //   e9????????           |                     
            //   0fb786c40a0000       | movzx               eax, word ptr [esi + 0xac4]

        $sequence_1 = { 8b5608 668986b8160000 88040a ff4614 }
            // n = 4, score = 300
            //   8b5608               | mov                 edx, dword ptr [esi + 8]
            //   668986b8160000       | mov                 word ptr [esi + 0x16b8], ax
            //   88040a               | mov                 byte ptr [edx + ecx], al
            //   ff4614               | inc                 dword ptr [esi + 0x14]

        $sequence_2 = { 0f82ab000000 8bcf c1e903 0fb603 83ef08 33c6 c1ee08 }
            // n = 7, score = 300
            //   0f82ab000000         | jb                  0xb1
            //   8bcf                 | mov                 ecx, edi
            //   c1e903               | shr                 ecx, 3
            //   0fb603               | movzx               eax, byte ptr [ebx]
            //   83ef08               | sub                 edi, 8
            //   33c6                 | xor                 eax, esi
            //   c1ee08               | shr                 esi, 8

        $sequence_3 = { 8bd0 896c2418 6bcaec 8bc5 89442410 }
            // n = 5, score = 300
            //   8bd0                 | mov                 edx, eax
            //   896c2418             | mov                 dword ptr [esp + 0x18], ebp
            //   6bcaec               | imul                ecx, edx, -0x14
            //   8bc5                 | mov                 eax, ebp
            //   89442410             | mov                 dword ptr [esp + 0x10], eax

        $sequence_4 = { 8d5e28 7409 ff7008 ff33 ff17 }
            // n = 5, score = 300
            //   8d5e28               | lea                 ebx, [esi + 0x28]
            //   7409                 | je                  0xb
            //   ff7008               | push                dword ptr [eax + 8]
            //   ff33                 | push                dword ptr [ebx]
            //   ff17                 | call                dword ptr [edi]

        $sequence_5 = { 3bc6 0f46f0 8b4738 56 03c1 }
            // n = 5, score = 300
            //   3bc6                 | cmp                 eax, esi
            //   0f46f0               | cmovbe              esi, eax
            //   8b4738               | mov                 eax, dword ptr [edi + 0x38]
            //   56                   | push                esi
            //   03c1                 | add                 eax, ecx

        $sequence_6 = { 896c2418 6bcaec 8bc5 89442410 03f9 8bcd 83ea01 }
            // n = 7, score = 300
            //   896c2418             | mov                 dword ptr [esp + 0x18], ebp
            //   6bcaec               | imul                ecx, edx, -0x14
            //   8bc5                 | mov                 eax, ebp
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   03f9                 | add                 edi, ecx
            //   8bcd                 | mov                 ecx, ebp
            //   83ea01               | sub                 edx, 1

        $sequence_7 = { 8b87a0160000 89542418 881401 ff87a0160000 8b97a0160000 }
            // n = 5, score = 300
            //   8b87a0160000         | mov                 eax, dword ptr [edi + 0x16a0]
            //   89542418             | mov                 dword ptr [esp + 0x18], edx
            //   881401               | mov                 byte ptr [ecx + eax], dl
            //   ff87a0160000         | inc                 dword ptr [edi + 0x16a0]
            //   8b97a0160000         | mov                 edx, dword ptr [edi + 0x16a0]

        $sequence_8 = { 6648 89742410 0fb7d0 8b87a0160000 }
            // n = 4, score = 300
            //   6648                 | dec                 ax
            //   89742410             | mov                 dword ptr [esp + 0x10], esi
            //   0fb7d0               | movzx               edx, ax
            //   8b87a0160000         | mov                 eax, dword ptr [edi + 0x16a0]

        $sequence_9 = { 8b4f6c 8b472c 2bce 2d06010000 }
            // n = 4, score = 300
            //   8b4f6c               | mov                 ecx, dword ptr [edi + 0x6c]
            //   8b472c               | mov                 eax, dword ptr [edi + 0x2c]
            //   2bce                 | sub                 ecx, esi
            //   2d06010000           | sub                 eax, 0x106

    condition:
        7 of them and filesize < 512000
}