rule win_nagini_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nagini."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nagini"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 06 0c07 06 0c07 06 0b06 }
            // n = 6, score = 100
            //   06                   | push                es
            //   0c07                 | or                  al, 7
            //   06                   | push                es
            //   0c07                 | or                  al, 7
            //   06                   | push                es
            //   0b06                 | or                  eax, dword ptr [esi]

        $sequence_1 = { e9???????? 6683f803 0f85c1020000 6804010000 8d842474010000 33f6 50 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   6683f803             | cmp                 ax, 3
            //   0f85c1020000         | jne                 0x2c7
            //   6804010000           | push                0x104
            //   8d842474010000       | lea                 eax, [esp + 0x174]
            //   33f6                 | xor                 esi, esi
            //   50                   | push                eax

        $sequence_2 = { 0f835ffbffff 03f3 03d3 83fb1f 0f8715040000 ff249da0c64000 8b46e4 }
            // n = 7, score = 100
            //   0f835ffbffff         | jae                 0xfffffb65
            //   03f3                 | add                 esi, ebx
            //   03d3                 | add                 edx, ebx
            //   83fb1f               | cmp                 ebx, 0x1f
            //   0f8715040000         | ja                  0x41b
            //   ff249da0c64000       | jmp                 dword ptr [ebx*4 + 0x40c6a0]
            //   8b46e4               | mov                 eax, dword ptr [esi - 0x1c]

        $sequence_3 = { 1408 0412 06 0213 07 0315???????? }
            // n = 6, score = 100
            //   1408                 | adc                 al, 8
            //   0412                 | add                 al, 0x12
            //   06                   | push                es
            //   0213                 | add                 dl, byte ptr [ebx]
            //   07                   | pop                 es
            //   0315????????         |                     

        $sequence_4 = { 59 8975fc 8b45e0 8b0485c0914200 f644030401 7428 }
            // n = 6, score = 100
            //   59                   | pop                 ecx
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8b0485c0914200       | mov                 eax, dword ptr [eax*4 + 0x4291c0]
            //   f644030401           | test                byte ptr [ebx + eax + 4], 1
            //   7428                 | je                  0x2a

        $sequence_5 = { ffd3 33c0 c744244007000000 c744243c00000000 668944242c 663907 }
            // n = 6, score = 100
            //   ffd3                 | call                ebx
            //   33c0                 | xor                 eax, eax
            //   c744244007000000     | mov                 dword ptr [esp + 0x40], 7
            //   c744243c00000000     | mov                 dword ptr [esp + 0x3c], 0
            //   668944242c           | mov                 word ptr [esp + 0x2c], ax
            //   663907               | cmp                 word ptr [edi], ax

        $sequence_6 = { 8d4c2448 e8???????? 83c404 c68424d802000006 83781408 7202 8b00 }
            // n = 7, score = 100
            //   8d4c2448             | lea                 ecx, [esp + 0x48]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c68424d802000006     | mov                 byte ptr [esp + 0x2d8], 6
            //   83781408             | cmp                 dword ptr [eax + 0x14], 8
            //   7202                 | jb                  4
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_7 = { 0305???????? 0305???????? 0404 0404 }
            // n = 4, score = 100
            //   0305????????         |                     
            //   0305????????         |                     
            //   0404                 | add                 al, 4
            //   0404                 | add                 al, 4

        $sequence_8 = { 0203 0903 040d 05060d0506 0d05060a04 }
            // n = 5, score = 100
            //   0203                 | add                 al, byte ptr [ebx]
            //   0903                 | or                  dword ptr [ebx], eax
            //   040d                 | add                 al, 0xd
            //   05060d0506           | add                 eax, 0x6050d06
            //   0d05060a04           | or                  eax, 0x40a0605

        $sequence_9 = { 83f85b 741d 83f85c 7418 }
            // n = 4, score = 100
            //   83f85b               | cmp                 eax, 0x5b
            //   741d                 | je                  0x1f
            //   83f85c               | cmp                 eax, 0x5c
            //   7418                 | je                  0x1a

    condition:
        7 of them and filesize < 12820480
}