rule win_neddnloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.neddnloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.neddnloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b450c 8908 ff15???????? 8bc7 5f }
            // n = 5, score = 400
            //   8b450c               | lea                 eax, [ebp + 0x30]
            //   8908                 | mov                 edx, 0x20000005
            //   ff15????????         |                     
            //   8bc7                 | mov                 dword ptr [ebp + 0x38], ebx
            //   5f                   | test                eax, eax

        $sequence_1 = { c3 0fbcc0 8945f8 c1e803 2b45fc }
            // n = 5, score = 400
            //   c3                   | jne                 3
            //   0fbcc0               | inc                 ecx
            //   8945f8               | mov                 eax, ecx
            //   c1e803               | sub                 eax, dword ptr [ebp - 4]
            //   2b45fc               | pop                 edi

        $sequence_2 = { 8b5508 69c0b179379e c1e813 33c9 66890c42 }
            // n = 5, score = 400
            //   8b5508               | sub                 esp, 0x610
            //   69c0b179379e         | xor                 eax, esp
            //   c1e813               | mov                 dword ptr [esp + 0x60c], eax
            //   33c9                 | mov                 eax, dword ptr [ebp + 0xc]
            //   66890c42             | mov                 dword ptr [eax], ecx

        $sequence_3 = { 7506 83c102 83c202 3bcb }
            // n = 4, score = 400
            //   7506                 | inc                 ecx
            //   83c102               | mov                 eax, ebx
            //   83c202               | dec                 eax
            //   3bcb                 | mov                 ebx, eax

        $sequence_4 = { 83c104 83c204 3bcf 72f0 8d43ff 3bc8 7311 }
            // n = 7, score = 400
            //   83c104               | dec                 eax
            //   83c204               | test                eax, eax
            //   3bcf                 | je                  0x45
            //   72f0                 | dec                 eax
            //   8d43ff               | mov                 ecx, eax
            //   3bc8                 | mov                 ebp, esp
            //   7311                 | and                 esp, 0xfffffff8

        $sequence_5 = { 8bec 83e4f8 81ec10060000 a1???????? 33c4 8984240c060000 }
            // n = 6, score = 400
            //   8bec                 | inc                 ecx
            //   83e4f8               | xor                 ebp, dword ptr [esi + eax*4 + 0x14880]
            //   81ec10060000         | inc                 ecx
            //   a1????????           |                     
            //   33c4                 | mov                 eax, eax
            //   8984240c060000       | dec                 esp

        $sequence_6 = { 3bc8 7311 0fb702 0fb731 663bc6 7506 }
            // n = 6, score = 400
            //   3bc8                 | je                  0xffffffa2
            //   7311                 | inc                 ecx
            //   0fb702               | xor                 esi, dword ptr [esp + ecx*4 + 0x14d80]
            //   0fb731               | inc                 ecx
            //   663bc6               | xor                 esi, dword ptr [esp + eax*4 + 0x15980]
            //   7506                 | inc                 ecx

        $sequence_7 = { 7501 41 8bc1 2b45fc 5f }
            // n = 5, score = 400
            //   7501                 | mov                 eax, eax
            //   41                   | inc                 ecx
            //   8bc1                 | xor                 esi, dword ptr [ebp + 0x10]
            //   2b45fc               | shr                 eax, 8
            //   5f                   | movzx               edx, al

        $sequence_8 = { ff15???????? e8???????? 488d1576570000 488d0d4f570000 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   e8????????           |                     
            //   488d1576570000       | jne                 0x13
            //   488d0d4f570000       | mov                 eax, 1

        $sequence_9 = { 4c8d4530 ba05000020 895d38 ff15???????? 85c0 749b }
            // n = 6, score = 100
            //   4c8d4530             | xor                 esp, dword ptr [ebp + 0xc]
            //   ba05000020           | cmp                 edi, 0xa
            //   895d38               | dec                 eax
            //   ff15????????         |                     
            //   85c0                 | lea                 edx, [0x5776]
            //   749b                 | dec                 eax

        $sequence_10 = { c1e818 0fb6c8 8bc3 c1eb10 }
            // n = 4, score = 100
            //   c1e818               | inc                 esp
            //   0fb6c8               | xor                 esp, dword ptr [ecx + eax*4 + 0x15580]
            //   8bc3                 | inc                 eax
            //   c1eb10               | movzx               eax, bh

        $sequence_11 = { 4433a48180550100 400fb6c7 8bbd00020000 4433a48180590100 488d2d96d0ffff 4533650c 83ff0a }
            // n = 7, score = 100
            //   4433a48180550100     | mov                 dword ptr [esp + 0x38], esi
            //   400fb6c7             | dec                 esp
            //   8bbd00020000         | mov                 edx, edx
            //   4433a48180590100     | dec                 esp
            //   488d2d96d0ffff       | mov                 ebx, ecx
            //   4533650c             | dec                 eax
            //   83ff0a               | cmp                 dword ptr [edx + 0x10], ebx

        $sequence_12 = { c1e818 0fb6c8 410fb6c0 4133ac8e803c0100 4133ac8680480100 418bc0 }
            // n = 6, score = 100
            //   c1e818               | mov                 edi, dword ptr [ebp + 0x200]
            //   0fb6c8               | inc                 esp
            //   410fb6c0             | xor                 esp, dword ptr [ecx + eax*4 + 0x15980]
            //   4133ac8e803c0100     | dec                 eax
            //   4133ac8680480100     | lea                 ebp, [0xffffd096]
            //   418bc0               | inc                 ebp

        $sequence_13 = { 4133b48c804d0100 4133b48480590100 418bc0 41337510 c1e808 0fb6d0 418bc3 }
            // n = 7, score = 100
            //   4133b48c804d0100     | lea                 ecx, [0x574f]
            //   4133b48480590100     | shr                 eax, 0x18
            //   418bc0               | movzx               ecx, al
            //   41337510             | mov                 eax, ebx
            //   c1e808               | shr                 ebx, 0x10
            //   0fb6d0               | shr                 eax, 0x18
            //   418bc3               | movzx               ecx, al

        $sequence_14 = { 4c8bd2 4c8bd9 48395a10 750a b801000000 }
            // n = 5, score = 100
            //   4c8bd2               | inc                 ecx
            //   4c8bd9               | sub                 ecx, edi
            //   48395a10             | inc                 ecx
            //   750a                 | mov                 eax, ecx
            //   b801000000           | dec                 eax

        $sequence_15 = { 418bcd 41b981808080 4c8bde 412bcf 418bc1 4889742438 }
            // n = 6, score = 100
            //   418bcd               | inc                 ecx
            //   41b981808080         | mov                 ecx, ebp
            //   4c8bde               | inc                 ecx
            //   412bcf               | mov                 ecx, 0x80808081
            //   418bc1               | dec                 esp
            //   4889742438           | mov                 ebx, esi

    condition:
        7 of them and filesize < 3438592
}