rule win_nestegg_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nestegg."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nestegg"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf8 3bfb 0f840efdffff 3bf3 7408 8b06 6a01 }
            // n = 7, score = 200
            //   8bf8                 | mov                 edi, eax
            //   3bfb                 | cmp                 edi, ebx
            //   0f840efdffff         | je                  0xfffffd14
            //   3bf3                 | cmp                 esi, ebx
            //   7408                 | je                  0xa
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   6a01                 | push                1

        $sequence_1 = { 7e1c 57 ffd3 8b4c2414 83c404 8d0c49 }
            // n = 6, score = 200
            //   7e1c                 | jle                 0x1e
            //   57                   | push                edi
            //   ffd3                 | call                ebx
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   83c404               | add                 esp, 4
            //   8d0c49               | lea                 ecx, [ecx + ecx*2]

        $sequence_2 = { 8a542414 83e207 668910 8b7c241c 8bcf e8???????? 8bcf }
            // n = 7, score = 200
            //   8a542414             | mov                 dl, byte ptr [esp + 0x14]
            //   83e207               | and                 edx, 7
            //   668910               | mov                 word ptr [eax], dx
            //   8b7c241c             | mov                 edi, dword ptr [esp + 0x1c]
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8bcf                 | mov                 ecx, edi

        $sequence_3 = { b801000000 5b 81c404280000 c3 5f 33c0 }
            // n = 6, score = 200
            //   b801000000           | mov                 eax, 1
            //   5b                   | pop                 ebx
            //   81c404280000         | add                 esp, 0x2804
            //   c3                   | ret                 
            //   5f                   | pop                 edi
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { 8d7c2415 c644241400 f3ab 8bb42418040000 6a04 }
            // n = 5, score = 200
            //   8d7c2415             | lea                 edi, [esp + 0x15]
            //   c644241400           | mov                 byte ptr [esp + 0x14], 0
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8bb42418040000       | mov                 esi, dword ptr [esp + 0x418]
            //   6a04                 | push                4

        $sequence_5 = { 33c0 53 8944240f 56 57 33db 8944241b }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   53                   | push                ebx
            //   8944240f             | mov                 dword ptr [esp + 0xf], eax
            //   56                   | push                esi
            //   57                   | push                edi
            //   33db                 | xor                 ebx, ebx
            //   8944241b             | mov                 dword ptr [esp + 0x1b], eax

        $sequence_6 = { 89743c20 81c700010000 6a00 8d442420 57 50 6a00 }
            // n = 7, score = 200
            //   89743c20             | mov                 dword ptr [esp + edi + 0x20], esi
            //   81c700010000         | add                 edi, 0x100
            //   6a00                 | push                0
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   57                   | push                edi
            //   50                   | push                eax
            //   6a00                 | push                0

        $sequence_7 = { 85c0 74d4 8b442410 8bcf 50 e8???????? }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   74d4                 | je                  0xffffffd6
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   8bcf                 | mov                 ecx, edi
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_8 = { 6a01 8d4c2424 c744243c00000000 c644241c00 c744241d00000000 }
            // n = 5, score = 200
            //   6a01                 | push                1
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   c744243c00000000     | mov                 dword ptr [esp + 0x3c], 0
            //   c644241c00           | mov                 byte ptr [esp + 0x1c], 0
            //   c744241d00000000     | mov                 dword ptr [esp + 0x1d], 0

        $sequence_9 = { 64a100000000 6aff 68???????? 50 b820410000 }
            // n = 5, score = 200
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   6aff                 | push                -1
            //   68????????           |                     
            //   50                   | push                eax
            //   b820410000           | mov                 eax, 0x4120

    condition:
        7 of them and filesize < 221184
}