rule win_netkey_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.netkey."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.netkey"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 50 8b4604 038528fdffff 50 8b46fc 038524fdffff }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   50                   | push                eax
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   038528fdffff         | add                 eax, dword ptr [ebp - 0x2d8]
            //   50                   | push                eax
            //   8b46fc               | mov                 eax, dword ptr [esi - 4]
            //   038524fdffff         | add                 eax, dword ptr [ebp - 0x2dc]

        $sequence_1 = { f30f7e05???????? 660fd6444e10 a1???????? 89444e18 ff15???????? 8bd8 85db }
            // n = 7, score = 200
            //   f30f7e05????????     |                     
            //   660fd6444e10         | movq                qword ptr [esi + ecx*2 + 0x10], xmm0
            //   a1????????           |                     
            //   89444e18             | mov                 dword ptr [esi + ecx*2 + 0x18], eax
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx

        $sequence_2 = { 8945f8 53 56 57 8bf9 8995e0feffff 83ffff }
            // n = 7, score = 200
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   8995e0feffff         | mov                 dword ptr [ebp - 0x120], edx
            //   83ffff               | cmp                 edi, -1

        $sequence_3 = { b802000000 53 668945d8 ff15???????? 8b3d???????? 668945da }
            // n = 6, score = 200
            //   b802000000           | mov                 eax, 2
            //   53                   | push                ebx
            //   668945d8             | mov                 word ptr [ebp - 0x28], ax
            //   ff15????????         |                     
            //   8b3d????????         |                     
            //   668945da             | mov                 word ptr [ebp - 0x26], ax

        $sequence_4 = { 57 33c0 8d3c9d241d4400 f00fb10f 8bc8 85c9 }
            // n = 6, score = 200
            //   57                   | push                edi
            //   33c0                 | xor                 eax, eax
            //   8d3c9d241d4400       | lea                 edi, [ebx*4 + 0x441d24]
            //   f00fb10f             | lock cmpxchg        dword ptr [edi], ecx
            //   8bc8                 | mov                 ecx, eax
            //   85c9                 | test                ecx, ecx

        $sequence_5 = { 8985dcfdffff 8b85ecfdffff 6a10 8985e0fdffff 8d85d8fdffff 50 6a00 }
            // n = 7, score = 200
            //   8985dcfdffff         | mov                 dword ptr [ebp - 0x224], eax
            //   8b85ecfdffff         | mov                 eax, dword ptr [ebp - 0x214]
            //   6a10                 | push                0x10
            //   8985e0fdffff         | mov                 dword ptr [ebp - 0x220], eax
            //   8d85d8fdffff         | lea                 eax, [ebp - 0x228]
            //   50                   | push                eax
            //   6a00                 | push                0

        $sequence_6 = { 2bca 51 57 8d4b18 e8???????? 57 }
            // n = 6, score = 200
            //   2bca                 | sub                 ecx, edx
            //   51                   | push                ecx
            //   57                   | push                edi
            //   8d4b18               | lea                 ecx, [ebx + 0x18]
            //   e8????????           |                     
            //   57                   | push                edi

        $sequence_7 = { 750b 8a45fb 88043e 46 }
            // n = 4, score = 200
            //   750b                 | jne                 0xd
            //   8a45fb               | mov                 al, byte ptr [ebp - 5]
            //   88043e               | mov                 byte ptr [esi + edi], al
            //   46                   | inc                 esi

        $sequence_8 = { 83c0fc 50 e8???????? 8b8db4efffff }
            // n = 4, score = 200
            //   83c0fc               | add                 eax, -4
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b8db4efffff         | mov                 ecx, dword ptr [ebp - 0x104c]

        $sequence_9 = { e8???????? 83c404 8d85f0efffff 50 6800040000 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8d85f0efffff         | lea                 eax, [ebp - 0x1010]
            //   50                   | push                eax
            //   6800040000           | push                0x400

    condition:
        7 of them and filesize < 606208
}