rule win_newpass_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.newpass."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.newpass"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffc2 48ffc1 83fa0a 72dc c605????????00 488b5dc8 488d55b8 }
            // n = 7, score = 700
            //   ffc2                 | mov                 edi, eax
            //   48ffc1               | dec                 esp
            //   83fa0a               | mov                 ecx, ebx
            //   72dc                 | dec                 eax
            //   c605????????00       |                     
            //   488b5dc8             | mov                 ecx, dword ptr [ecx]
            //   488d55b8             | dec                 eax

        $sequence_1 = { 498b0f e8???????? 49c747180f000000 4d896f10 41c60700 498bc4 }
            // n = 6, score = 700
            //   498b0f               | jne                 0x1b60
            //   e8????????           |                     
            //   49c747180f000000     | int3                
            //   4d896f10             | dec                 eax
            //   41c60700             | lea                 edi, [0xa449e]
            //   498bc4               | jne                 0x1b6a

        $sequence_2 = { 0fb705???????? 48c7455807000000 48895d50 66895d40 6685c0 7505 }
            // n = 6, score = 700
            //   0fb705????????       |                     
            //   48c7455807000000     | cmp                 byte ptr [ecx + 0x19], 0
            //   48895d50             | jne                 0x777
            //   66895d40             | dec                 ecx
            //   6685c0               | mov                 eax, dword ptr [ecx + 0x10]
            //   7505                 | cmp                 byte ptr [eax + 0x19], 0

        $sequence_3 = { 83c2c9 eb25 80e961 80f905 7705 83c2a9 }
            // n = 6, score = 700
            //   83c2c9               | cmp                 ebx, eax
            //   eb25                 | jne                 0x727
            //   80e961               | or                  eax, 0xffffffff
            //   80f905               | dec                 eax
            //   7705                 | add                 ebx, 8
            //   83c2a9               | dec                 eax

        $sequence_4 = { 49d1e8 483bc8 4c0f47c2 4d85c0 744a 482bf9 0fb7041f }
            // n = 7, score = 700
            //   49d1e8               | mov                 dword ptr [ebp + 0x68], edi
            //   483bc8               | dec                 ecx
            //   4c0f47c2             | lea                 edx, [esi + 0x40]
            //   4d85c0               | dec                 eax
            //   744a                 | mov                 ebx, eax
            //   482bf9               | dec                 ecx
            //   0fb7041f             | cmp                 eax, dword ptr [esp]

        $sequence_5 = { 4c3bff 4d0f42c7 4d85c0 7504 33c0 eb05 e8???????? }
            // n = 7, score = 700
            //   4c3bff               | dec                 ebp
            //   4d0f42c7             | test                edi, edi
            //   4d85c0               | je                  0x1828
            //   7504                 | dec                 eax
            //   33c0                 | mov                 dword ptr [ebp + 0xf], 0xf
            //   eb05                 | dec                 esp
            //   e8????????           |                     

        $sequence_6 = { 4c0f47c2 4d85c0 744a 482bf9 0fb7041f 0fb70b 48ffc2 }
            // n = 7, score = 700
            //   4c0f47c2             | cmp                 dword ptr [eax + eax*2], 0
            //   4d85c0               | jne                 0x18c4
            //   744a                 | dec                 eax
            //   482bf9               | lea                 eax, [ebp + 0x230]
            //   0fb7041f             | dec                 eax
            //   0fb70b               | mov                 dword ptr [ebp + 0xc0], eax
            //   48ffc2               | jne                 0x18f2

        $sequence_7 = { eb13 4983c8ff 0f1f440000 49ffc0 43803c0200 75f6 498bd2 }
            // n = 7, score = 700
            //   eb13                 | dec                 eax
            //   4983c8ff             | mov                 ecx, eax
            //   0f1f440000           | jmp                 0x7e0
            //   49ffc0               | dec                 ecx
            //   43803c0200           | mov                 eax, esi
            //   75f6                 | dec                 eax
            //   498bd2               | mov                 dword ptr [esp + 0x20], edi

        $sequence_8 = { 488939 4885ff 783f 48b800000000ffffffff c7411006320000 ba063a0000 }
            // n = 6, score = 700
            //   488939               | lea                 edx, [0x8060b]
            //   4885ff               | mov                 ecx, 0xca
            //   783f                 | jmp                 0x8f0
            //   48b800000000ffffffff     | jne    0x8fe
            //   c7411006320000       | dec                 eax
            //   ba063a0000           | lea                 edx, [0x6160b]

        $sequence_9 = { 498bd5 488bcb e8???????? 84c0 0f84f4feffff eb1e 4c8b6c2438 }
            // n = 7, score = 700
            //   498bd5               | dec                 eax
            //   488bcb               | lea                 edx, [ecx + 8]
            //   e8????????           |                     
            //   84c0                 | dec                 esp
            //   0f84f4feffff         | sub                 eax, edx
            //   eb1e                 | dec                 eax
            //   4c8b6c2438           | mov                 eax, dword ptr [edi + 0x20]

    condition:
        7 of them and filesize < 2654208
}