rule win_oddjob_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.oddjob."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.oddjob"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8845da 8845df 8845fa 8845fb 8b4508 6a40 052a080000 }
            // n = 7, score = 100
            //   8845da               | mov                 byte ptr [ebp - 0x26], al
            //   8845df               | mov                 byte ptr [ebp - 0x21], al
            //   8845fa               | mov                 byte ptr [ebp - 6], al
            //   8845fb               | mov                 byte ptr [ebp - 5], al
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   6a40                 | push                0x40
            //   052a080000           | add                 eax, 0x82a

        $sequence_1 = { 8b450c 85c0 74f2 8365f800 85ff 7677 8945f4 }
            // n = 7, score = 100
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   85c0                 | test                eax, eax
            //   74f2                 | je                  0xfffffff4
            //   8365f800             | and                 dword ptr [ebp - 8], 0
            //   85ff                 | test                edi, edi
            //   7677                 | jbe                 0x79
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

        $sequence_2 = { c685c1f8ffff68 c685c2f8ffff8e c685c3f8ffff4e c685c4f8ffff0e c685c5f8ffffec 8885c6f8ffff c685c7f8ffffb5 }
            // n = 7, score = 100
            //   c685c1f8ffff68       | mov                 byte ptr [ebp - 0x73f], 0x68
            //   c685c2f8ffff8e       | mov                 byte ptr [ebp - 0x73e], 0x8e
            //   c685c3f8ffff4e       | mov                 byte ptr [ebp - 0x73d], 0x4e
            //   c685c4f8ffff0e       | mov                 byte ptr [ebp - 0x73c], 0xe
            //   c685c5f8ffffec       | mov                 byte ptr [ebp - 0x73b], 0xec
            //   8885c6f8ffff         | mov                 byte ptr [ebp - 0x73a], al
            //   c685c7f8ffffb5       | mov                 byte ptr [ebp - 0x739], 0xb5

        $sequence_3 = { c68530feffffc2 c68531feffff04 889d32feffff c68533feffff83 c68534feffffc4 }
            // n = 5, score = 100
            //   c68530feffffc2       | mov                 byte ptr [ebp - 0x1d0], 0xc2
            //   c68531feffff04       | mov                 byte ptr [ebp - 0x1cf], 4
            //   889d32feffff         | mov                 byte ptr [ebp - 0x1ce], bl
            //   c68533feffff83       | mov                 byte ptr [ebp - 0x1cd], 0x83
            //   c68534feffffc4       | mov                 byte ptr [ebp - 0x1cc], 0xc4

        $sequence_4 = { e8???????? 89858494ffff 3bc3 7506 899da494ffff 6a08 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   89858494ffff         | mov                 dword ptr [ebp - 0x6b7c], eax
            //   3bc3                 | cmp                 eax, ebx
            //   7506                 | jne                 8
            //   899da494ffff         | mov                 dword ptr [ebp - 0x6b5c], ebx
            //   6a08                 | push                8

        $sequence_5 = { 3bcf 8955fc 7ce0 33c9 394d0c 762b }
            // n = 6, score = 100
            //   3bcf                 | cmp                 ecx, edi
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   7ce0                 | jl                  0xffffffe2
            //   33c9                 | xor                 ecx, ecx
            //   394d0c               | cmp                 dword ptr [ebp + 0xc], ecx
            //   762b                 | jbe                 0x2d

        $sequence_6 = { 0bc6 0fb67102 0fb64903 c1e008 33f2 0bc6 33ca }
            // n = 7, score = 100
            //   0bc6                 | or                  eax, esi
            //   0fb67102             | movzx               esi, byte ptr [ecx + 2]
            //   0fb64903             | movzx               ecx, byte ptr [ecx + 3]
            //   c1e008               | shl                 eax, 8
            //   33f2                 | xor                 esi, edx
            //   0bc6                 | or                  eax, esi
            //   33ca                 | xor                 ecx, edx

        $sequence_7 = { 885e1a c785b0feffff01000000 885e10 8b4dfc 8b85b0feffff 5f 33cd }
            // n = 7, score = 100
            //   885e1a               | mov                 byte ptr [esi + 0x1a], bl
            //   c785b0feffff01000000     | mov    dword ptr [ebp - 0x150], 1
            //   885e10               | mov                 byte ptr [esi + 0x10], bl
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b85b0feffff         | mov                 eax, dword ptr [ebp - 0x150]
            //   5f                   | pop                 edi
            //   33cd                 | xor                 ecx, ebp

        $sequence_8 = { 50 ff5108 3bfe 7405 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   ff5108               | call                dword ptr [ecx + 8]
            //   3bfe                 | cmp                 edi, esi
            //   7405                 | je                  7

        $sequence_9 = { e8???????? ff75f0 d1eb 53 57 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   d1eb                 | shr                 ebx, 1
            //   53                   | push                ebx
            //   57                   | push                edi

    condition:
        7 of them and filesize < 221184
}