rule win_orcus_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-04-21"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.3.1"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.orcus_rat"
        malpedia_version = "20200421"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using yara-signator.
     * The code and documentation / approach will be published in the near future here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { d01d02000000 8618 8005????????93 06 ec 1d02000000 e101 }
            // n = 7, score = 100
            //   d01d02000000         | rcr                 byte ptr [2], 1
            //   8618                 | xchg                byte ptr [eax], bl
            //   8005????????93       |                     
            //   06                   | push                es
            //   ec                   | in                  al, dx
            //   1d02000000           | sbb                 eax, 2
            //   e101                 | loope               3

        $sequence_1 = { 8bec a2???????? b541 b17e b19d c3 }
            // n = 6, score = 100
            //   8bec                 | mov                 ebp, esp
            //   a2????????           |                     
            //   b541                 | mov                 ch, 0x41
            //   b17e                 | mov                 cl, 0x7e
            //   b19d                 | mov                 cl, 0x9d
            //   c3                   | ret                 

        $sequence_2 = { 8618 8005????????93 06 ec 1d02000000 }
            // n = 5, score = 100
            //   8618                 | xchg                byte ptr [eax], bl
            //   8005????????93       |                     
            //   06                   | push                es
            //   ec                   | in                  al, dx
            //   1d02000000           | sbb                 eax, 2

        $sequence_3 = { 129bc108ed27 4b c57eb2 4c }
            // n = 4, score = 100
            //   129bc108ed27         | adc                 bl, byte ptr [ebx + 0x27ed08c1]
            //   4b                   | dec                 ebx
            //   c57eb2               | lds                 edi, ptr [esi - 0x4e]
            //   4c                   | dec                 esp

        $sequence_4 = { b17e b19d c3 2f 96 49 fd }
            // n = 7, score = 100
            //   b17e                 | mov                 cl, 0x7e
            //   b19d                 | mov                 cl, 0x9d
            //   c3                   | ret                 
            //   2f                   | das                 
            //   96                   | xchg                eax, esi
            //   49                   | dec                 ecx
            //   fd                   | std                 

        $sequence_5 = { 4c ec 27 cb e9???????? }
            // n = 5, score = 100
            //   4c                   | dec                 esp
            //   ec                   | in                  al, dx
            //   27                   | daa                 
            //   cb                   | retf                
            //   e9????????           |                     

        $sequence_6 = { 49 fd 129bc108ed27 4b c57eb2 4c }
            // n = 6, score = 100
            //   49                   | dec                 ecx
            //   fd                   | std                 
            //   129bc108ed27         | adc                 bl, byte ptr [ebx + 0x27ed08c1]
            //   4b                   | dec                 ebx
            //   c57eb2               | lds                 edi, ptr [esi - 0x4e]
            //   4c                   | dec                 esp

        $sequence_7 = { 48 ff4848 48 ff4848 }
            // n = 4, score = 100
            //   48                   | dec                 eax
            //   ff4848               | dec                 dword ptr [eax + 0x48]
            //   48                   | dec                 eax
            //   ff4848               | dec                 dword ptr [eax + 0x48]

        $sequence_8 = { 4b c57eb2 4c ec 27 }
            // n = 5, score = 100
            //   4b                   | dec                 ebx
            //   c57eb2               | lds                 edi, ptr [esi - 0x4e]
            //   4c                   | dec                 esp
            //   ec                   | in                  al, dx
            //   27                   | daa                 

        $sequence_9 = { 06 d01d02000000 8618 8005????????93 06 ec }
            // n = 6, score = 100
            //   06                   | push                es
            //   d01d02000000         | rcr                 byte ptr [2], 1
            //   8618                 | xchg                byte ptr [eax], bl
            //   8005????????93       |                     
            //   06                   | push                es
            //   ec                   | in                  al, dx

    condition:
        7 of them and filesize < 2638848
}
