rule win_pandabanker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pandabanker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pandabanker"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85f6 7e26 8be8 8d831c020000 8bd8 }
            // n = 5, score = 8600
            //   85f6                 | test                esi, esi
            //   7e26                 | jle                 0x28
            //   8be8                 | mov                 ebp, eax
            //   8d831c020000         | lea                 eax, [ebx + 0x21c]
            //   8bd8                 | mov                 ebx, eax

        $sequence_1 = { 5a 0f45d0 8bce e8???????? }
            // n = 4, score = 8600
            //   5a                   | pop                 edx
            //   0f45d0               | cmovne              edx, eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_2 = { 8bf0 85f6 746d 8b470c 25fffeffff 89460c 8b4714 }
            // n = 7, score = 8600
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   746d                 | je                  0x6f
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   25fffeffff           | and                 eax, 0xfffffeff
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   8b4714               | mov                 eax, dword ptr [edi + 0x14]

        $sequence_3 = { 8b36 4a 85f6 75f5 }
            // n = 4, score = 8600
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   4a                   | dec                 edx
            //   85f6                 | test                esi, esi
            //   75f5                 | jne                 0xfffffff7

        $sequence_4 = { 8bcf 42 e8???????? 85c0 741c 85db 7407 }
            // n = 7, score = 8600
            //   8bcf                 | mov                 ecx, edi
            //   42                   | inc                 edx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   741c                 | je                  0x1e
            //   85db                 | test                ebx, ebx
            //   7407                 | je                  9

        $sequence_5 = { 8bc6 5e c3 8a01 3c30 7c0c }
            // n = 6, score = 8600
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   3c30                 | cmp                 al, 0x30
            //   7c0c                 | jl                  0xe

        $sequence_6 = { 46 33c9 803a2d 7504 }
            // n = 4, score = 8600
            //   46                   | inc                 esi
            //   33c9                 | xor                 ecx, ecx
            //   803a2d               | cmp                 byte ptr [edx], 0x2d
            //   7504                 | jne                 6

        $sequence_7 = { 8b4e18 8bd5 e8???????? 85c0 }
            // n = 4, score = 8600
            //   8b4e18               | mov                 ecx, dword ptr [esi + 0x18]
            //   8bd5                 | mov                 edx, ebp
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_8 = { 896c240c 8bda 57 83feff 7509 8bcb e8???????? }
            // n = 7, score = 8600
            //   896c240c             | mov                 dword ptr [esp + 0xc], ebp
            //   8bda                 | mov                 ebx, edx
            //   57                   | push                edi
            //   83feff               | cmp                 esi, -1
            //   7509                 | jne                 0xb
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     

        $sequence_9 = { 88542412 80e380 88542411 8ae2 }
            // n = 4, score = 8600
            //   88542412             | mov                 byte ptr [esp + 0x12], dl
            //   80e380               | and                 bl, 0x80
            //   88542411             | mov                 byte ptr [esp + 0x11], dl
            //   8ae2                 | mov                 ah, dl

    condition:
        7 of them and filesize < 417792
}