rule win_parasite_http_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.parasite_http."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.parasite_http"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7509 8bce e8???????? ebe0 8bc6 5f }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7509                 | jne                 0xb
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   ebe0                 | jmp                 0xffffffe2
            //   8bc6                 | mov                 eax, esi
            //   5f                   | pop                 edi

        $sequence_1 = { 85f6 5e 5b 750a 837dfc00 7504 33c0 }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   750a                 | jne                 0xc
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { c745f8???????? c745fc???????? 8b4cb5e4 e8???????? 8bf8 85ff 7412 }
            // n = 7, score = 100
            //   c745f8????????       |                     
            //   c745fc????????       |                     
            //   8b4cb5e4             | mov                 ecx, dword ptr [ebp + esi*4 - 0x1c]
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   7412                 | je                  0x14

        $sequence_3 = { 0f84e2000000 e8???????? bf50450000 85c0 7418 8b483c }
            // n = 6, score = 100
            //   0f84e2000000         | je                  0xe8
            //   e8????????           |                     
            //   bf50450000           | mov                 edi, 0x4550
            //   85c0                 | test                eax, eax
            //   7418                 | je                  0x1a
            //   8b483c               | mov                 ecx, dword ptr [eax + 0x3c]

        $sequence_4 = { be???????? 8bce e8???????? 8bd0 8bce e8???????? 8bf0 }
            // n = 7, score = 100
            //   be????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_5 = { 75fa 53 6800000008 6a40 8d45e8 894de8 }
            // n = 6, score = 100
            //   75fa                 | jne                 0xfffffffc
            //   53                   | push                ebx
            //   6800000008           | push                0x8000000
            //   6a40                 | push                0x40
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx

        $sequence_6 = { e8???????? 8bc8 e8???????? b900040000 8945f8 e8???????? 8b0d???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   b900040000           | mov                 ecx, 0x400
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   e8????????           |                     
            //   8b0d????????         |                     

        $sequence_7 = { 57 85c0 7419 e8???????? 0345fc 59 50 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   85c0                 | test                eax, eax
            //   7419                 | je                  0x1b
            //   e8????????           |                     
            //   0345fc               | add                 eax, dword ptr [ebp - 4]
            //   59                   | pop                 ecx
            //   50                   | push                eax

        $sequence_8 = { 33c0 b910040000 40 a3???????? 8d85dcfbffff 8818 40 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   b910040000           | mov                 ecx, 0x410
            //   40                   | inc                 eax
            //   a3????????           |                     
            //   8d85dcfbffff         | lea                 eax, [ebp - 0x424]
            //   8818                 | mov                 byte ptr [eax], bl
            //   40                   | inc                 eax

        $sequence_9 = { ffd0 5f 5e 5b 5d c20c00 53 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 147456
}