rule win_pcshare_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pcshare."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pcshare"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d7c2418 33c0 f3a5 66a5 b935000000 }
            // n = 5, score = 100
            //   8d7c2418             | lea                 edi, [esp + 0x18]
            //   33c0                 | xor                 eax, eax
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   b935000000           | mov                 ecx, 0x35

        $sequence_1 = { c744242c01000000 e8???????? 8b8c24e0010000 8dbc2410010000 33c0 83c410 8d5910 }
            // n = 7, score = 100
            //   c744242c01000000     | mov                 dword ptr [esp + 0x2c], 1
            //   e8????????           |                     
            //   8b8c24e0010000       | mov                 ecx, dword ptr [esp + 0x1e0]
            //   8dbc2410010000       | lea                 edi, [esp + 0x110]
            //   33c0                 | xor                 eax, eax
            //   83c410               | add                 esp, 0x10
            //   8d5910               | lea                 ebx, [ecx + 0x10]

        $sequence_2 = { 8bf0 85f6 7630 8b4d04 2bc6 50 8d1431 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   7630                 | jbe                 0x32
            //   8b4d04               | mov                 ecx, dword ptr [ebp + 4]
            //   2bc6                 | sub                 eax, esi
            //   50                   | push                eax
            //   8d1431               | lea                 edx, [ecx + esi]

        $sequence_3 = { 894124 c7413800000000 c7413c00000000 895134 c20c00 6aff 68???????? }
            // n = 7, score = 100
            //   894124               | mov                 dword ptr [ecx + 0x24], eax
            //   c7413800000000       | mov                 dword ptr [ecx + 0x38], 0
            //   c7413c00000000       | mov                 dword ptr [ecx + 0x3c], 0
            //   895134               | mov                 dword ptr [ecx + 0x34], edx
            //   c20c00               | ret                 0xc
            //   6aff                 | push                -1
            //   68????????           |                     

        $sequence_4 = { e8???????? 895c2450 51 8d4c2414 8bc4 c784247801000004000000 89642468 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   895c2450             | mov                 dword ptr [esp + 0x50], ebx
            //   51                   | push                ecx
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   8bc4                 | mov                 eax, esp
            //   c784247801000004000000     | mov    dword ptr [esp + 0x178], 4
            //   89642468             | mov                 dword ptr [esp + 0x68], esp

        $sequence_5 = { 3bc6 7505 b8???????? 6a05 68???????? 50 e8???????? }
            // n = 7, score = 100
            //   3bc6                 | cmp                 eax, esi
            //   7505                 | jne                 7
            //   b8????????           |                     
            //   6a05                 | push                5
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_6 = { 0fb641ff 0fb6d2 3bc2 0f8794000000 8088e184061004 40 ebee }
            // n = 7, score = 100
            //   0fb641ff             | movzx               eax, byte ptr [ecx - 1]
            //   0fb6d2               | movzx               edx, dl
            //   3bc2                 | cmp                 eax, edx
            //   0f8794000000         | ja                  0x9a
            //   8088e184061004       | or                  byte ptr [eax + 0x100684e1], 4
            //   40                   | inc                 eax
            //   ebee                 | jmp                 0xfffffff0

        $sequence_7 = { 56 8d4c2418 88442418 e8???????? 8b0d???????? 51 56 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   88442418             | mov                 byte ptr [esp + 0x18], al
            //   e8????????           |                     
            //   8b0d????????         |                     
            //   51                   | push                ecx
            //   56                   | push                esi

        $sequence_8 = { c644242800 8b4508 89442410 8bf8 8d442410 897c2418 50 }
            // n = 7, score = 100
            //   c644242800           | mov                 byte ptr [esp + 0x28], 0
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   8bf8                 | mov                 edi, eax
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   897c2418             | mov                 dword ptr [esp + 0x18], edi
            //   50                   | push                eax

        $sequence_9 = { 8b4c2410 8d0431 50 e8???????? 8b4c2414 83c404 03c8 }
            // n = 7, score = 100
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   8d0431               | lea                 eax, [ecx + esi]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   83c404               | add                 esp, 4
            //   03c8                 | add                 ecx, eax

    condition:
        7 of them and filesize < 893708
}