rule win_petrwrap_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.petrwrap."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.petrwrap"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83bf9c00000000 7422 e8???????? 89869c000000 85c0 744d ffb79c000000 }
            // n = 7, score = 100
            //   83bf9c00000000       | cmp                 dword ptr [edi + 0x9c], 0
            //   7422                 | je                  0x24
            //   e8????????           |                     
            //   89869c000000         | mov                 dword ptr [esi + 0x9c], eax
            //   85c0                 | test                eax, eax
            //   744d                 | je                  0x4f
            //   ffb79c000000         | push                dword ptr [edi + 0x9c]

        $sequence_1 = { 8d4304 55 53 50 e8???????? 50 56 }
            // n = 7, score = 100
            //   8d4304               | lea                 eax, [ebx + 4]
            //   55                   | push                ebp
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_2 = { 894c2444 8b28 8b5804 8bc5 8bcb 0facc813 8bfd }
            // n = 7, score = 100
            //   894c2444             | mov                 dword ptr [esp + 0x44], ecx
            //   8b28                 | mov                 ebp, dword ptr [eax]
            //   8b5804               | mov                 ebx, dword ptr [eax + 4]
            //   8bc5                 | mov                 eax, ebp
            //   8bcb                 | mov                 ecx, ebx
            //   0facc813             | shrd                eax, ecx, 0x13
            //   8bfd                 | mov                 edi, ebp

        $sequence_3 = { 8b8c2418010000 11460c 8b442428 014610 8b442420 114614 8b442450 }
            // n = 7, score = 100
            //   8b8c2418010000       | mov                 ecx, dword ptr [esp + 0x118]
            //   11460c               | adc                 dword ptr [esi + 0xc], eax
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   014610               | add                 dword ptr [esi + 0x10], eax
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   114614               | adc                 dword ptr [esi + 0x14], eax
            //   8b442450             | mov                 eax, dword ptr [esp + 0x50]

        $sequence_4 = { 85c0 0f85ab000000 837dec00 0f84a1000000 8b55f4 8b049580db4600 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   0f85ab000000         | jne                 0xb1
            //   837dec00             | cmp                 dword ptr [ebp - 0x14], 0
            //   0f84a1000000         | je                  0xa7
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8b049580db4600       | mov                 eax, dword ptr [edx*4 + 0x46db80]

        $sequence_5 = { 53 55 57 6a0a ffd1 83c410 8bc6 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   57                   | push                edi
            //   6a0a                 | push                0xa
            //   ffd1                 | call                ecx
            //   83c410               | add                 esp, 0x10
            //   8bc6                 | mov                 eax, esi

        $sequence_6 = { 8b4d00 89450c 8b03 894c2424 8d04b0 2bf2 c1fe1f }
            // n = 7, score = 100
            //   8b4d00               | mov                 ecx, dword ptr [ebp]
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   894c2424             | mov                 dword ptr [esp + 0x24], ecx
            //   8d04b0               | lea                 eax, [eax + esi*4]
            //   2bf2                 | sub                 esi, edx
            //   c1fe1f               | sar                 esi, 0x1f

        $sequence_7 = { 3b4608 7f04 8bc6 eb12 50 56 e8???????? }
            // n = 7, score = 100
            //   3b4608               | cmp                 eax, dword ptr [esi + 8]
            //   7f04                 | jg                  6
            //   8bc6                 | mov                 eax, esi
            //   eb12                 | jmp                 0x14
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_8 = { 83c410 837df000 741e 90 8d45ec 6a3a 50 }
            // n = 7, score = 100
            //   83c410               | add                 esp, 0x10
            //   837df000             | cmp                 dword ptr [ebp - 0x10], 0
            //   741e                 | je                  0x20
            //   90                   | nop                 
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   6a3a                 | push                0x3a
            //   50                   | push                eax

        $sequence_9 = { 687f010000 68???????? 8d0480 03c0 6a12 6a09 89442458 }
            // n = 7, score = 100
            //   687f010000           | push                0x17f
            //   68????????           |                     
            //   8d0480               | lea                 eax, [eax + eax*4]
            //   03c0                 | add                 eax, eax
            //   6a12                 | push                0x12
            //   6a09                 | push                9
            //   89442458             | mov                 dword ptr [esp + 0x58], eax

    condition:
        7 of them and filesize < 1024000
}