rule win_phorpiex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.phorpiex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.phorpiex"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 85c0 740f 6a07 }
            // n = 4, score = 1100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   740f                 | je                  0x11
            //   6a07                 | push                7

        $sequence_1 = { 6a00 ff15???????? ff15???????? 50 e8???????? }
            // n = 5, score = 1100
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   ff15????????         |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_2 = { ff15???????? 85c0 741f 6880000000 }
            // n = 4, score = 1000
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   741f                 | je                  0x21
            //   6880000000           | push                0x80

        $sequence_3 = { 6a20 6a00 6a00 6a00 8b5508 }
            // n = 5, score = 900
            //   6a20                 | push                0x20
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_4 = { 83c410 6a00 6a02 6a02 6a00 6a00 }
            // n = 6, score = 900
            //   83c410               | add                 esp, 0x10
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   6a02                 | push                2
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_5 = { 6a01 6a00 68???????? e8???????? 83c40c 33c0 }
            // n = 6, score = 800
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { e8???????? 99 b90d000000 f7f9 }
            // n = 4, score = 800
            //   e8????????           |                     
            //   99                   | cdq                 
            //   b90d000000           | mov                 ecx, 0xd
            //   f7f9                 | idiv                ecx

        $sequence_7 = { e8???????? 83c404 e8???????? e8???????? ff15???????? 6a00 }
            // n = 6, score = 800
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   e8????????           |                     
            //   e8????????           |                     
            //   ff15????????         |                     
            //   6a00                 | push                0

        $sequence_8 = { 52 683f000f00 6a00 68???????? 6802000080 ff15???????? 85c0 }
            // n = 7, score = 700
            //   52                   | push                edx
            //   683f000f00           | push                0xf003f
            //   6a00                 | push                0
            //   68????????           |                     
            //   6802000080           | push                0x80000002
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_9 = { 68???????? ff15???????? 8d85f8fdffff 50 68???????? }
            // n = 5, score = 700
            //   68????????           |                     
            //   ff15????????         |                     
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_10 = { 6a00 682a800000 6a00 ff15???????? }
            // n = 4, score = 700
            //   6a00                 | push                0
            //   682a800000           | push                0x802a
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_11 = { ff15???????? 6a00 ff15???????? 85c0 7418 ff15???????? }
            // n = 6, score = 700
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7418                 | je                  0x1a
            //   ff15????????         |                     

        $sequence_12 = { 6a01 ff15???????? ff15???????? b001 }
            // n = 4, score = 700
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   ff15????????         |                     
            //   b001                 | mov                 al, 1

        $sequence_13 = { f7f9 81c210270000 52 e8???????? }
            // n = 4, score = 600
            //   f7f9                 | idiv                ecx
            //   81c210270000         | add                 edx, 0x2710
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_14 = { 52 e8???????? 83c418 eb04 }
            // n = 4, score = 600
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   eb04                 | jmp                 6

        $sequence_15 = { 68???????? ff15???????? e9???????? 8d45fc }
            // n = 4, score = 600
            //   68????????           |                     
            //   ff15????????         |                     
            //   e9????????           |                     
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_16 = { ff15???????? 8945f8 837df800 7429 8b45f8 50 }
            // n = 6, score = 600
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7429                 | je                  0x2b
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   50                   | push                eax

        $sequence_17 = { ff15???????? 8945fc 837dfc00 7416 8b4df8 51 ff15???????? }
            // n = 7, score = 600
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7416                 | je                  0x18
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_18 = { 50 e8???????? 59 59 85c0 0f85c0000000 }
            // n = 6, score = 500
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   0f85c0000000         | jne                 0xc6

        $sequence_19 = { 3d00010000 7504 83c8ff c3 8b542404 }
            // n = 5, score = 500
            //   3d00010000           | cmp                 eax, 0x100
            //   7504                 | jne                 6
            //   83c8ff               | or                  eax, 0xffffffff
            //   c3                   | ret                 
            //   8b542404             | mov                 edx, dword ptr [esp + 4]

        $sequence_20 = { 3db7000000 7508 6a00 ff15???????? 6804010000 }
            // n = 5, score = 500
            //   3db7000000           | cmp                 eax, 0xb7
            //   7508                 | jne                 0xa
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   6804010000           | push                0x104

        $sequence_21 = { 6a21 50 e8???????? c60000 }
            // n = 4, score = 500
            //   6a21                 | push                0x21
            //   50                   | push                eax
            //   e8????????           |                     
            //   c60000               | mov                 byte ptr [eax], 0

        $sequence_22 = { 52 e8???????? 99 b960ea0000 f7f9 }
            // n = 5, score = 400
            //   52                   | push                edx
            //   e8????????           |                     
            //   99                   | cdq                 
            //   b960ea0000           | mov                 ecx, 0xea60
            //   f7f9                 | idiv                ecx

        $sequence_23 = { 85c0 746b 8b9424b8000000 8a8414a8000000 8d9414a8000000 84c0 }
            // n = 6, score = 400
            //   85c0                 | test                eax, eax
            //   746b                 | je                  0x6d
            //   8b9424b8000000       | mov                 edx, dword ptr [esp + 0xb8]
            //   8a8414a8000000       | mov                 al, byte ptr [esp + edx + 0xa8]
            //   8d9414a8000000       | lea                 edx, [esp + edx + 0xa8]
            //   84c0                 | test                al, al

        $sequence_24 = { 50 68???????? 8d4c2468 68ff010000 51 e8???????? 6a40 }
            // n = 7, score = 400
            //   50                   | push                eax
            //   68????????           |                     
            //   8d4c2468             | lea                 ecx, [esp + 0x68]
            //   68ff010000           | push                0x1ff
            //   51                   | push                ecx
            //   e8????????           |                     
            //   6a40                 | push                0x40

        $sequence_25 = { 81ec20010000 56 57 6a00 6a00 6a03 6a00 }
            // n = 7, score = 400
            //   81ec20010000         | sub                 esp, 0x120
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a03                 | push                3
            //   6a00                 | push                0

        $sequence_26 = { 40 41 663bc2 72f7 53 33c0 }
            // n = 6, score = 300
            //   40                   | inc                 eax
            //   41                   | inc                 ecx
            //   663bc2               | cmp                 ax, dx
            //   72f7                 | jb                  0xfffffff9
            //   53                   | push                ebx
            //   33c0                 | xor                 eax, eax

        $sequence_27 = { 50 8d45ec 50 6805000020 }
            // n = 4, score = 300
            //   50                   | push                eax
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   6805000020           | push                0x20000005

        $sequence_28 = { 56 57 68e8030000 ff15???????? e8???????? be???????? }
            // n = 6, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   68e8030000           | push                0x3e8
            //   ff15????????         |                     
            //   e8????????           |                     
            //   be????????           |                     

        $sequence_29 = { 8d45f8 50 8d45e4 50 6805000020 }
            // n = 5, score = 200
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   50                   | push                eax
            //   6805000020           | push                0x20000005

    condition:
        7 of them and filesize < 2490368
}