rule win_photolite_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.photolite."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.photolite"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b801000000 4883c430 5b c3 4883ec28 }
            // n = 5, score = 400
            //   b801000000           | xor                 eax, 0x7799dd10
            //   4883c430             | mov                 dword ptr [ebp + ecx*4 + 0xa0], eax
            //   5b                   | dec                 eax
            //   c3                   | add                 ecx, edi
            //   4883ec28             | dec                 ecx

        $sequence_1 = { 899504030000 8b85f8020000 8a85f4020000 84c0 751b 488bcb }
            // n = 6, score = 400
            //   899504030000         | mov                 dword ptr [ebp + 0x304], edx
            //   8b85f8020000         | mov                 eax, dword ptr [ebp + 0x2f8]
            //   8a85f4020000         | mov                 al, byte ptr [ebp + 0x2f4]
            //   84c0                 | test                al, al
            //   751b                 | jne                 0x1d
            //   488bcb               | dec                 eax

        $sequence_2 = { 72ea 889da0010000 ba36a2b43b c785a40100005dc7c655 }
            // n = 4, score = 400
            //   72ea                 | mov                 ecx, ebx
            //   889da0010000         | jb                  0xffffffec
            //   ba36a2b43b           | mov                 byte ptr [ebp + 0x1a0], bl
            //   c785a40100005dc7c655     | mov    edx, 0x3bb4a236

        $sequence_3 = { 8a441140 320411 88840ce0000000 48ffc1 4883f920 72e2 }
            // n = 6, score = 400
            //   8a441140             | cmp                 ecx, esi
            //   320411               | jb                  0xffffffed
            //   88840ce0000000       | dec                 eax
            //   48ffc1               | lea                 edx, [ebp + 0x5f0]
            //   4883f920             | mov                 eax, 1
            //   72e2                 | dec                 eax

        $sequence_4 = { 84c0 751e 488bcb 8b848dd8040000 3566115674 89848dd8040000 4803cf }
            // n = 7, score = 400
            //   84c0                 | mov                 dword ptr [ebp + 0x1a4], 0x55c6c75d
            //   751e                 | test                al, al
            //   488bcb               | jne                 0x20
            //   8b848dd8040000       | dec                 eax
            //   3566115674           | mov                 ecx, ebx
            //   89848dd8040000       | mov                 eax, dword ptr [ebp + ecx*4 + 0x4d8]
            //   4803cf               | xor                 eax, 0x74561166

        $sequence_5 = { 0fb7d1 eb07 498d5602 4803d1 498bcc }
            // n = 5, score = 400
            //   0fb7d1               | mov                 dword ptr [ebp + ecx*4 + 0x4d8], eax
            //   eb07                 | dec                 eax
            //   498d5602             | add                 ecx, edi
            //   4803d1               | movzx               edx, cx
            //   498bcc               | jmp                 9

        $sequence_6 = { 889df4020000 babea80905 c785f8020000d5cd7b6b c785fc020000dbc43a37 c7850003000090cc6569 899504030000 }
            // n = 6, score = 400
            //   889df4020000         | dec                 ecx
            //   babea80905           | lea                 edx, [esi + 2]
            //   c785f8020000d5cd7b6b     | dec    eax
            //   c785fc020000dbc43a37     | add    edx, ecx
            //   c7850003000090cc6569     | dec    ecx
            //   899504030000         | mov                 ecx, esp

        $sequence_7 = { 3510dd9977 89848da0000000 4803cf 493bce 72e5 488d95f0050000 }
            // n = 6, score = 400
            //   3510dd9977           | mov                 byte ptr [ebp + 0x2f4], bl
            //   89848da0000000       | mov                 edx, 0x509a8be
            //   4803cf               | mov                 dword ptr [ebp + 0x2f8], 0x6b7bcdd5
            //   493bce               | mov                 dword ptr [ebp + 0x2fc], 0x373ac4db
            //   72e5                 | mov                 dword ptr [ebp + 0x300], 0x6965cc90
            //   488d95f0050000       | mov                 dword ptr [ebp + 0x304], edx

        $sequence_8 = { 83ff03 0f82e8feffff 0f1f840000000000 488b05???????? }
            // n = 4, score = 100
            //   83ff03               | xor                 eax, 0x74561166
            //   0f82e8feffff         | mov                 dword ptr [ebp + ecx*4 + 0x4d8], eax
            //   0f1f840000000000     | dec                 eax
            //   488b05????????       |                     

        $sequence_9 = { 33d2 41b800800000 488bcf ffd0 0fb65310 }
            // n = 5, score = 100
            //   33d2                 | mov                 edx, 0x509a8be
            //   41b800800000         | mov                 dword ptr [ebp + 0x2f8], 0x6b7bcdd5
            //   488bcf               | mov                 dword ptr [ebp + 0x2fc], 0x373ac4db
            //   ffd0                 | mov                 dword ptr [ebp + 0x300], 0x6965cc90
            //   0fb65310             | mov                 dword ptr [ebp + 0x304], edx

        $sequence_10 = { 7532 8d5001 33c9 41b8d18a3146 }
            // n = 4, score = 100
            //   7532                 | add                 edx, ecx
            //   8d5001               | dec                 ecx
            //   33c9                 | mov                 ecx, esp
            //   41b8d18a3146         | mov                 byte ptr [ebp + 0x2f4], bl

        $sequence_11 = { 488bfa 488bf1 4d85c0 0f8482000000 4c8b15???????? 4d85d2 7516 }
            // n = 7, score = 100
            //   488bfa               | add                 ecx, edi
            //   488bf1               | movzx               edx, cx
            //   4d85c0               | jmp                 0xc
            //   0f8482000000         | dec                 ecx
            //   4c8b15????????       |                     
            //   4d85d2               | lea                 edx, [esi + 2]
            //   7516                 | dec                 eax

        $sequence_12 = { 488d8dc0000000 ff15???????? 4c8b05???????? c785e804000000010000 4d85c0 7516 418d5002 }
            // n = 7, score = 100
            //   488d8dc0000000       | dec                 eax
            //   ff15????????         |                     
            //   4c8b05????????       |                     
            //   c785e804000000010000     | add    esp, 0x30
            //   4d85c0               | pop                 ebx
            //   7516                 | ret                 
            //   418d5002             | dec                 eax

        $sequence_13 = { b840000000 488d4c2450 0f1f4000 c60100 488d4901 4883e801 75f3 }
            // n = 7, score = 100
            //   b840000000           | xor                 eax, 0x7799dd10
            //   488d4c2450           | mov                 dword ptr [ebp + ecx*4 + 0xa0], eax
            //   0f1f4000             | dec                 eax
            //   c60100               | add                 ecx, edi
            //   488d4901             | dec                 ecx
            //   4883e801             | cmp                 ecx, esi
            //   75f3                 | jb                  0xffffffed

        $sequence_14 = { 33c9 41b8f572993d e8???????? b988130000 }
            // n = 4, score = 100
            //   33c9                 | dec                 eax
            //   41b8f572993d         | lea                 edx, [ebp + 0x5f0]
            //   e8????????           |                     
            //   b988130000           | mov                 eax, 1

        $sequence_15 = { 4c897da0 448965d8 4c8965d0 e8???????? 3dc8000000 0f849d000000 488b5d28 }
            // n = 7, score = 100
            //   4c897da0             | mov                 dword ptr [ebp + 0x1a4], 0x55c6c75d
            //   448965d8             | test                al, al
            //   4c8965d0             | jne                 0x22
            //   e8????????           |                     
            //   3dc8000000           | dec                 eax
            //   0f849d000000         | mov                 ecx, ebx
            //   488b5d28             | mov                 eax, dword ptr [ebp + ecx*4 + 0x4d8]

    condition:
        7 of them and filesize < 99328
}