rule win_photoloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.photoloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.photoloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fa2 894704 33c9 b800000040 }
            // n = 4, score = 1600
            //   0fa2                 | cpuid               
            //   894704               | mov                 dword ptr [edi + 4], eax
            //   33c9                 | xor                 ecx, ecx
            //   b800000040           | mov                 eax, 0x40000000

        $sequence_1 = { b800000040 0fa2 895f0c e8???????? }
            // n = 4, score = 1600
            //   b800000040           | mov                 eax, 0x40000000
            //   0fa2                 | cpuid               
            //   895f0c               | mov                 dword ptr [edi + 0xc], ebx
            //   e8????????           |                     

        $sequence_2 = { f7411400000020 7407 8b41f8 3901 }
            // n = 4, score = 1600
            //   f7411400000020       | test                dword ptr [ecx + 0x14], 0x20000000
            //   7407                 | je                  9
            //   8b41f8               | mov                 eax, dword ptr [ecx - 8]
            //   3901                 | cmp                 dword ptr [ecx], eax

        $sequence_3 = { b801000000 0fa2 89442420 895c2424 894c2428 8954242c }
            // n = 6, score = 1600
            //   b801000000           | mov                 eax, 1
            //   0fa2                 | cpuid               
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   895c2424             | mov                 dword ptr [esp + 0x24], ebx
            //   894c2428             | mov                 dword ptr [esp + 0x28], ecx
            //   8954242c             | mov                 dword ptr [esp + 0x2c], edx

        $sequence_4 = { 25ffffff00 0d00000005 e9???????? 8bd7 397b1c 7640 8bc2 }
            // n = 7, score = 1600
            //   25ffffff00           | and                 eax, 0xffffff
            //   0d00000005           | or                  eax, 0x5000000
            //   e9????????           |                     
            //   8bd7                 | mov                 edx, edi
            //   397b1c               | cmp                 dword ptr [ebx + 0x1c], edi
            //   7640                 | jbe                 0x42
            //   8bc2                 | mov                 eax, edx

        $sequence_5 = { c0c003 0fb6c8 8bc1 83e10f }
            // n = 4, score = 1600
            //   c0c003               | rol                 al, 3
            //   0fb6c8               | movzx               ecx, al
            //   8bc1                 | mov                 eax, ecx
            //   83e10f               | and                 ecx, 0xf

        $sequence_6 = { 8bf7 8d6f10 ff15???????? 0f31 }
            // n = 4, score = 1600
            //   8bf7                 | mov                 esi, edi
            //   8d6f10               | lea                 ebp, [edi + 0x10]
            //   ff15????????         |                     
            //   0f31                 | rdtsc               

        $sequence_7 = { 488b5c2408 c3 0f31 4f8d1489 48c1e220 478b4cd308 480bc2 }
            // n = 7, score = 1500
            //   488b5c2408           | dec                 eax
            //   c3                   | mov                 ebx, dword ptr [esp + 8]
            //   0f31                 | ret                 
            //   4f8d1489             | rdtsc               
            //   48c1e220             | dec                 edi
            //   478b4cd308           | lea                 edx, [ecx + ecx*4]
            //   480bc2               | dec                 eax

        $sequence_8 = { ff15???????? 25ffffff00 0d00000007 eb4a }
            // n = 4, score = 1500
            //   ff15????????         |                     
            //   25ffffff00           | or                  eax, 0x5000000
            //   0d00000007           | mov                 edx, edi
            //   eb4a                 | cmp                 dword ptr [ebx + 0x1c], edi

        $sequence_9 = { 7507 66c74424287800 8d442428 ba???????? }
            // n = 4, score = 200
            //   7507                 | lea                 ebp, [esp + 0x10]
            //   66c74424287800       | xor                 ecx, ecx
            //   8d442428             | mov                 eax, 0x80000001
            //   ba????????           |                     

        $sequence_10 = { 85f6 7431 8b06 33ff 8bce 47 eb05 }
            // n = 7, score = 200
            //   85f6                 | movzx               ecx, al
            //   7431                 | mov                 eax, ecx
            //   8b06                 | and                 ecx, 0xf
            //   33ff                 | add                 edi, eax
            //   8bce                 | lea                 ecx, [ebx + edi*2]
            //   47                   | mov                 eax, ebx
            //   eb05                 | mov                 esi, eax

        $sequence_11 = { 8bf0 8d6c2410 33c9 b801000080 0fa2 894500 895d04 }
            // n = 7, score = 200
            //   8bf0                 | mov                 edx, edi
            //   8d6c2410             | cmp                 dword ptr [ebx + 0x1c], edi
            //   33c9                 | jbe                 0x42
            //   b801000080           | mov                 eax, 0x40000000
            //   0fa2                 | cpuid               
            //   894500               | mov                 dword ptr [edi + 0xc], ebx
            //   895d04               | mov                 dword ptr [edi + 4], eax

        $sequence_12 = { 741a 57 8bfb 8bc8 2bfa 66890c17 }
            // n = 6, score = 200
            //   741a                 | xor                 ecx, ecx
            //   57                   | mov                 eax, 0x40000000
            //   8bfb                 | cpuid               
            //   8bc8                 | mov                 dword ptr [edi + 0xc], ebx
            //   2bfa                 | inc                 esp
            //   66890c17             | mov                 eax, edx

        $sequence_13 = { ff15???????? 8bf0 85f6 746d 8d442418 50 8d442414 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   8bf0                 | rdtsc               
            //   85f6                 | dec                 eax
            //   746d                 | shl                 edx, 0x20
            //   8d442418             | dec                 eax
            //   50                   | or                  eax, edx
            //   8d442414             | rol                 al, 3

        $sequence_14 = { ff542420 0f31 8bc8 8bf2 0f31 }
            // n = 5, score = 200
            //   ff542420             | cpuid               
            //   0f31                 | mov                 dword ptr [ebp], eax
            //   8bc8                 | mov                 dword ptr [ebp + 4], ebx
            //   8bf2                 | je                  0x1c
            //   0f31                 | push                edi

        $sequence_15 = { e8???????? 03f8 8d0c7b e8???????? 8bc3 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   03f8                 | mov                 dword ptr [esp + 0x24], ebx
            //   8d0c7b               | and                 eax, 0xffffff
            //   e8????????           |                     
            //   8bc3                 | or                  eax, 0x5000000

    condition:
        7 of them and filesize < 107520
}