rule win_pikabot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pikabot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pikabot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ebd3 8b4508 c9 c3 55 8bec }
            // n = 6, score = 1100
            //   ebd3                 | jmp                 0xffffffd5
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_1 = { 8bec 83ec0c 8b4508 8945fc 8b450c 8945f8 8b4510 }
            // n = 7, score = 1000
            //   8bec                 | mov                 ebp, esp
            //   83ec0c               | sub                 esp, 0xc
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_2 = { 8b45f8 40 8945f8 ebd3 8b4508 }
            // n = 5, score = 1000
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   40                   | inc                 eax
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   ebd3                 | jmp                 0xffffffd5
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_3 = { 8b4df8 8a09 8808 8b45fc 40 8945fc 8b45f8 }
            // n = 7, score = 1000
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8a09                 | mov                 cl, byte ptr [ecx]
            //   8808                 | mov                 byte ptr [eax], cl
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   40                   | inc                 eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_4 = { 8b4510 48 894510 837df400 741a 8b45fc 8b4df8 }
            // n = 7, score = 1000
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   48                   | dec                 eax
            //   894510               | mov                 dword ptr [ebp + 0x10], eax
            //   837df400             | cmp                 dword ptr [ebp - 0xc], 0
            //   741a                 | je                  0x1c
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]

        $sequence_5 = { 7ce9 8b4214 2b420c 5f }
            // n = 4, score = 900
            //   7ce9                 | jl                  0xffffffeb
            //   8b4214               | mov                 eax, dword ptr [edx + 0x14]
            //   2b420c               | sub                 eax, dword ptr [edx + 0xc]
            //   5f                   | pop                 edi

        $sequence_6 = { 8a1c08 8d4320 0fb6c8 8d53bf 80fa19 0fb6c3 }
            // n = 6, score = 800
            //   8a1c08               | mov                 bl, byte ptr [eax + ecx]
            //   8d4320               | lea                 eax, [ebx + 0x20]
            //   0fb6c8               | movzx               ecx, al
            //   8d53bf               | lea                 edx, [ebx - 0x41]
            //   80fa19               | cmp                 dl, 0x19
            //   0fb6c3               | movzx               eax, bl

        $sequence_7 = { 3bc7 72d5 5b 5f 8bc6 }
            // n = 5, score = 700
            //   3bc7                 | cmp                 eax, edi
            //   72d5                 | jb                  0xffffffd7
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi
            //   8bc6                 | mov                 eax, esi

        $sequence_8 = { 57 8bfa 85c9 7436 85ff }
            // n = 5, score = 700
            //   57                   | push                edi
            //   8bfa                 | mov                 edi, edx
            //   85c9                 | test                ecx, ecx
            //   7436                 | je                  0x38
            //   85ff                 | test                edi, edi

        $sequence_9 = { 6a08 0f43c8 33c1 83fa40 }
            // n = 4, score = 700
            //   6a08                 | push                8
            //   0f43c8               | cmovae              ecx, eax
            //   33c1                 | xor                 eax, ecx
            //   83fa40               | cmp                 edx, 0x40

        $sequence_10 = { 8801 41 8a040a 84c0 75f6 c60100 8bc6 }
            // n = 7, score = 700
            //   8801                 | mov                 byte ptr [ecx], al
            //   41                   | inc                 ecx
            //   8a040a               | mov                 al, byte ptr [edx + ecx]
            //   84c0                 | test                al, al
            //   75f6                 | jne                 0xfffffff8
            //   c60100               | mov                 byte ptr [ecx], 0
            //   8bc6                 | mov                 eax, esi

        $sequence_11 = { 8b0cba 03ce e8???????? 8bd0 }
            // n = 4, score = 700
            //   8b0cba               | mov                 ecx, dword ptr [edx + edi*4]
            //   03ce                 | add                 ecx, esi
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax

        $sequence_12 = { 53 56 8b35???????? b84d5a0000 57 8955fc 663906 }
            // n = 7, score = 700
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b35????????         |                     
            //   b84d5a0000           | mov                 eax, 0x5a4d
            //   57                   | push                edi
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   663906               | cmp                 word ptr [esi], ax

        $sequence_13 = { e8???????? 8bd0 e8???????? 3b45fc }
            // n = 4, score = 700
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   e8????????           |                     
            //   3b45fc               | cmp                 eax, dword ptr [ebp - 4]

        $sequence_14 = { 0fabd0 83fa20 6a08 0f43c8 }
            // n = 4, score = 700
            //   0fabd0               | bts                 eax, edx
            //   83fa20               | cmp                 edx, 0x20
            //   6a08                 | push                8
            //   0f43c8               | cmovae              ecx, eax

        $sequence_15 = { 56 8bf1 85c9 7419 85d2 }
            // n = 5, score = 700
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   85c9                 | test                ecx, ecx
            //   7419                 | je                  0x1b
            //   85d2                 | test                edx, edx

        $sequence_16 = { 0345f8 03c8 0fb6c9 894df8 }
            // n = 4, score = 600
            //   0345f8               | add                 eax, dword ptr [ebp - 8]
            //   03c8                 | add                 ecx, eax
            //   0fb6c9               | movzx               ecx, cl
            //   894df8               | mov                 dword ptr [ebp - 8], ecx

        $sequence_17 = { 0fb6d1 03c2 0fb6c0 8945f0 }
            // n = 4, score = 600
            //   0fb6d1               | movzx               edx, cl
            //   03c2                 | add                 eax, edx
            //   0fb6c0               | movzx               eax, al
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax

        $sequence_18 = { 40 3d00010000 72f1 8bf2 }
            // n = 4, score = 600
            //   40                   | inc                 eax
            //   3d00010000           | cmp                 eax, 0x100
            //   72f1                 | jb                  0xfffffff3
            //   8bf2                 | mov                 esi, edx

        $sequence_19 = { 81f900010000 72f0 8bf0 33d2 }
            // n = 4, score = 600
            //   81f900010000         | cmp                 ecx, 0x100
            //   72f0                 | jb                  0xfffffff2
            //   8bf0                 | mov                 esi, eax
            //   33d2                 | xor                 edx, edx

        $sequence_20 = { 3d00010000 72f1 8b35???????? 8bf9 }
            // n = 4, score = 600
            //   3d00010000           | cmp                 eax, 0x100
            //   72f1                 | jb                  0xfffffff3
            //   8b35????????         |                     
            //   8bf9                 | mov                 edi, ecx

        $sequence_21 = { 8b01 0d20202020 3d6e74646c 750f }
            // n = 4, score = 400
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   0d20202020           | or                  eax, 0x20202020
            //   3d6e74646c           | cmp                 eax, 0x6c64746e
            //   750f                 | jne                 0x11

        $sequence_22 = { 8d4400ff 5d c3 55 89e5 57 56 }
            // n = 7, score = 300
            //   8d4400ff             | lea                 eax, [eax + eax - 1]
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   57                   | push                edi
            //   56                   | push                esi

        $sequence_23 = { 893c24 e8???????? 31c9 894c2410 }
            // n = 4, score = 300
            //   893c24               | mov                 dword ptr [esp], edi
            //   e8????????           |                     
            //   31c9                 | xor                 ecx, ecx
            //   894c2410             | mov                 dword ptr [esp + 0x10], ecx

        $sequence_24 = { a1???????? 8b00 890424 e8???????? a1???????? 8b9060010000 89542404 }
            // n = 7, score = 300
            //   a1????????           |                     
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   a1????????           |                     
            //   8b9060010000         | mov                 edx, dword ptr [eax + 0x160]
            //   89542404             | mov                 dword ptr [esp + 4], edx

        $sequence_25 = { 890424 e8???????? 8b4308 29f0 }
            // n = 4, score = 300
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8b4308               | mov                 eax, dword ptr [ebx + 8]
            //   29f0                 | sub                 eax, esi

        $sequence_26 = { c744240448020000 c7042440000000 a1???????? ff5050 31c9 52 }
            // n = 6, score = 300
            //   c744240448020000     | mov                 dword ptr [esp + 4], 0x248
            //   c7042440000000       | mov                 dword ptr [esp], 0x40
            //   a1????????           |                     
            //   ff5050               | call                dword ptr [eax + 0x50]
            //   31c9                 | xor                 ecx, ecx
            //   52                   | push                edx

        $sequence_27 = { 893c24 a1???????? ff90ec000000 52 52 85c0 }
            // n = 6, score = 300
            //   893c24               | mov                 dword ptr [esp], edi
            //   a1????????           |                     
            //   ff90ec000000         | call                dword ptr [eax + 0xec]
            //   52                   | push                edx
            //   52                   | push                edx
            //   85c0                 | test                eax, eax

        $sequence_28 = { 89442408 31c0 89442404 890424 }
            // n = 4, score = 300
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   31c0                 | xor                 eax, eax
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   890424               | mov                 dword ptr [esp], eax

    condition:
        7 of them and filesize < 1717248
}