rule win_plaintee_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.plaintee."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.plaintee"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 56 50 ff15???????? 83f85a 721a }
            // n = 6, score = 300
            //   52                   | push                edx
            //   56                   | push                esi
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83f85a               | cmp                 eax, 0x5a
            //   721a                 | jb                  0x1c

        $sequence_1 = { 898638010000 750a b001 5e 81c490010000 c3 8bce }
            // n = 7, score = 300
            //   898638010000         | mov                 dword ptr [esi + 0x138], eax
            //   750a                 | jne                 0xc
            //   b001                 | mov                 al, 1
            //   5e                   | pop                 esi
            //   81c490010000         | add                 esp, 0x190
            //   c3                   | ret                 
            //   8bce                 | mov                 ecx, esi

        $sequence_2 = { 740a b001 5e 81c490010000 c3 6a11 }
            // n = 6, score = 300
            //   740a                 | je                  0xc
            //   b001                 | mov                 al, 1
            //   5e                   | pop                 esi
            //   81c490010000         | add                 esp, 0x190
            //   c3                   | ret                 
            //   6a11                 | push                0x11

        $sequence_3 = { 56 e8???????? 85c0 754c 68ac010000 e8???????? }
            // n = 6, score = 300
            //   56                   | push                esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   754c                 | jne                 0x4e
            //   68ac010000           | push                0x1ac
            //   e8????????           |                     

        $sequence_4 = { ff15???????? 83f85a 721a 8a16 }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   83f85a               | cmp                 eax, 0x5a
            //   721a                 | jb                  0x1c
            //   8a16                 | mov                 dl, byte ptr [esi]

        $sequence_5 = { 8b4c240c b801000000 80c20a 3bf0 8811 7e0f 53 }
            // n = 7, score = 300
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   b801000000           | mov                 eax, 1
            //   80c20a               | add                 dl, 0xa
            //   3bf0                 | cmp                 esi, eax
            //   8811                 | mov                 byte ptr [ecx], dl
            //   7e0f                 | jle                 0x11
            //   53                   | push                ebx

        $sequence_6 = { 6a02 ff15???????? 83f8ff 898638010000 750a }
            // n = 5, score = 300
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1
            //   898638010000         | mov                 dword ptr [esi + 0x138], eax
            //   750a                 | jne                 0xc

        $sequence_7 = { 7e0f 53 8a1c31 32da 881c31 }
            // n = 5, score = 300
            //   7e0f                 | jle                 0x11
            //   53                   | push                ebx
            //   8a1c31               | mov                 bl, byte ptr [ecx + esi]
            //   32da                 | xor                 bl, dl
            //   881c31               | mov                 byte ptr [ecx + esi], bl

        $sequence_8 = { 8a1c31 32da 881c31 41 3bc8 7cf3 }
            // n = 6, score = 300
            //   8a1c31               | mov                 bl, byte ptr [ecx + esi]
            //   32da                 | xor                 bl, dl
            //   881c31               | mov                 byte ptr [ecx + esi], bl
            //   41                   | inc                 ecx
            //   3bc8                 | cmp                 ecx, eax
            //   7cf3                 | jl                  0xfffffff5

        $sequence_9 = { 66ab aa b916000000 33c0 }
            // n = 4, score = 300
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   b916000000           | mov                 ecx, 0x16
            //   33c0                 | xor                 eax, eax

    condition:
        7 of them and filesize < 73728
}