rule win_poldat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.poldat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.poldat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b35???????? 6a08 66ab 58 }
            // n = 4, score = 100
            //   8b35????????         |                     
            //   6a08                 | push                8
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   58                   | pop                 eax

        $sequence_1 = { 57 6a05 6a00 68???????? }
            // n = 4, score = 100
            //   57                   | push                edi
            //   6a05                 | push                5
            //   6a00                 | push                0
            //   68????????           |                     

        $sequence_2 = { 50 e8???????? 68fe010000 8d86b8070000 57 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   68fe010000           | push                0x1fe
            //   8d86b8070000         | lea                 eax, [esi + 0x7b8]
            //   57                   | push                edi

        $sequence_3 = { 8a50ff 881431 41 48 3d???????? 7ff1 8d45fc }
            // n = 7, score = 100
            //   8a50ff               | mov                 dl, byte ptr [eax - 1]
            //   881431               | mov                 byte ptr [ecx + esi], dl
            //   41                   | inc                 ecx
            //   48                   | dec                 eax
            //   3d????????           |                     
            //   7ff1                 | jg                  0xfffffff3
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_4 = { 8b0c9d68c34100 8b5e04 23ca 03cb 33db 8a1cce 8d34ce }
            // n = 7, score = 100
            //   8b0c9d68c34100       | mov                 ecx, dword ptr [ebx*4 + 0x41c368]
            //   8b5e04               | mov                 ebx, dword ptr [esi + 4]
            //   23ca                 | and                 ecx, edx
            //   03cb                 | add                 ecx, ebx
            //   33db                 | xor                 ebx, ebx
            //   8a1cce               | mov                 bl, byte ptr [esi + ecx*8]
            //   8d34ce               | lea                 esi, [esi + ecx*8]

        $sequence_5 = { 50 ff15???????? 56 e8???????? 59 5f 5e }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_6 = { 8b4c241c 8b0c8d68c34100 23cf 03c1 8b4c241c d3ef 03ca }
            // n = 7, score = 100
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   8b0c8d68c34100       | mov                 ecx, dword ptr [ecx*4 + 0x41c368]
            //   23cf                 | and                 ecx, edi
            //   03c1                 | add                 eax, ecx
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   d3ef                 | shr                 edi, cl
            //   03ca                 | add                 ecx, edx

        $sequence_7 = { 750a c74720a0324000 895728 395724 7507 }
            // n = 5, score = 100
            //   750a                 | jne                 0xc
            //   c74720a0324000       | mov                 dword ptr [edi + 0x20], 0x4032a0
            //   895728               | mov                 dword ptr [edi + 0x28], edx
            //   395724               | cmp                 dword ptr [edi + 0x24], edx
            //   7507                 | jne                 9

        $sequence_8 = { 7233 e9???????? 8b4c243c 8b5c2410 8b7104 c7411824d84100 }
            // n = 6, score = 100
            //   7233                 | jb                  0x35
            //   e9????????           |                     
            //   8b4c243c             | mov                 ecx, dword ptr [esp + 0x3c]
            //   8b5c2410             | mov                 ebx, dword ptr [esp + 0x10]
            //   8b7104               | mov                 esi, dword ptr [ecx + 4]
            //   c7411824d84100       | mov                 dword ptr [ecx + 0x18], 0x41d824

        $sequence_9 = { f7f9 8bfa ffd6 50 }
            // n = 4, score = 100
            //   f7f9                 | idiv                ecx
            //   8bfa                 | mov                 edi, edx
            //   ffd6                 | call                esi
            //   50                   | push                eax

    condition:
        7 of them and filesize < 247808
}