rule win_polpo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.polpo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.polpo"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c745bc436f6e6e c745c065637469 c745c46f6e3a20 c745c84b656570 c745cc2d616c69 66c745d07665 884dd3 }
            // n = 7, score = 100
            //   c745bc436f6e6e       | mov                 dword ptr [ebp - 0x44], 0x6e6e6f43
            //   c745c065637469       | mov                 dword ptr [ebp - 0x40], 0x69746365
            //   c745c46f6e3a20       | mov                 dword ptr [ebp - 0x3c], 0x203a6e6f
            //   c745c84b656570       | mov                 dword ptr [ebp - 0x38], 0x7065654b
            //   c745cc2d616c69       | mov                 dword ptr [ebp - 0x34], 0x696c612d
            //   66c745d07665         | mov                 word ptr [ebp - 0x30], 0x6576
            //   884dd3               | mov                 byte ptr [ebp - 0x2d], cl

        $sequence_1 = { 51 8d95dcf7ffff 52 e8???????? 8d85d4f7ffff 50 8d8ddcf7ffff }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8d95dcf7ffff         | lea                 edx, [ebp - 0x824]
            //   52                   | push                edx
            //   e8????????           |                     
            //   8d85d4f7ffff         | lea                 eax, [ebp - 0x82c]
            //   50                   | push                eax
            //   8d8ddcf7ffff         | lea                 ecx, [ebp - 0x824]

        $sequence_2 = { e8???????? 8be5 5d c20800 81fe00001000 0f878c000000 8b87a0040000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   81fe00001000         | cmp                 esi, 0x100000
            //   0f878c000000         | ja                  0x92
            //   8b87a0040000         | mov                 eax, dword ptr [edi + 0x4a0]

        $sequence_3 = { 57 6800040000 8d95ecfbffff 68???????? 52 e8???????? 83c410 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   6800040000           | push                0x400
            //   8d95ecfbffff         | lea                 edx, [ebp - 0x414]
            //   68????????           |                     
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10

        $sequence_4 = { 85d2 7534 8d45f8 50 e8???????? 8d4df8 51 }
            // n = 7, score = 100
            //   85d2                 | test                edx, edx
            //   7534                 | jne                 0x36
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   51                   | push                ecx

        $sequence_5 = { 8bc8 83e103 837d0c00 f3a4 741c 8b85a0fdffff 8d959cfdffff }
            // n = 7, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   83e103               | and                 ecx, 3
            //   837d0c00             | cmp                 dword ptr [ebp + 0xc], 0
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   741c                 | je                  0x1e
            //   8b85a0fdffff         | mov                 eax, dword ptr [ebp - 0x260]
            //   8d959cfdffff         | lea                 edx, [ebp - 0x264]

        $sequence_6 = { 8995b0fbffff 8a10 40 84d2 75f9 2b85b0fbffff baff020000 }
            // n = 7, score = 100
            //   8995b0fbffff         | mov                 dword ptr [ebp - 0x450], edx
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   40                   | inc                 eax
            //   84d2                 | test                dl, dl
            //   75f9                 | jne                 0xfffffffb
            //   2b85b0fbffff         | sub                 eax, dword ptr [ebp - 0x450]
            //   baff020000           | mov                 edx, 0x2ff

        $sequence_7 = { 83c1f0 51 8945dd 8945e1 8945e5 8945e9 8945ed }
            // n = 7, score = 100
            //   83c1f0               | add                 ecx, -0x10
            //   51                   | push                ecx
            //   8945dd               | mov                 dword ptr [ebp - 0x23], eax
            //   8945e1               | mov                 dword ptr [ebp - 0x1f], eax
            //   8945e5               | mov                 dword ptr [ebp - 0x1b], eax
            //   8945e9               | mov                 dword ptr [ebp - 0x17], eax
            //   8945ed               | mov                 dword ptr [ebp - 0x13], eax

        $sequence_8 = { 83e03f 0fb680c0940120 83e23f 41 884602 8a92c0940120 885603 }
            // n = 7, score = 100
            //   83e03f               | and                 eax, 0x3f
            //   0fb680c0940120       | movzx               eax, byte ptr [eax + 0x200194c0]
            //   83e23f               | and                 edx, 0x3f
            //   41                   | inc                 ecx
            //   884602               | mov                 byte ptr [esi + 2], al
            //   8a92c0940120         | mov                 dl, byte ptr [edx + 0x200194c0]
            //   885603               | mov                 byte ptr [esi + 3], dl

        $sequence_9 = { 50 8d4ddc 51 8d954cffffff 52 8bce }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   51                   | push                ecx
            //   8d954cffffff         | lea                 edx, [ebp - 0xb4]
            //   52                   | push                edx
            //   8bce                 | mov                 ecx, esi

    condition:
        7 of them and filesize < 250880
}