rule win_pony_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pony."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pony"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff75fc ff15???????? 5e c9 c20400 55 8bec }
            // n = 7, score = 800
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_1 = { 8d840744eabea4 034604 c1c004 03c3 8bfb 33f9 33f8 }
            // n = 7, score = 800
            //   8d840744eabea4       | lea                 eax, [edi + eax - 0x5b4115bc]
            //   034604               | add                 eax, dword ptr [esi + 4]
            //   c1c004               | rol                 eax, 4
            //   03c3                 | add                 eax, ebx
            //   8bfb                 | mov                 edi, ebx
            //   33f9                 | xor                 edi, ecx
            //   33f8                 | xor                 edi, eax

        $sequence_2 = { e8???????? ffb5dcf7ffff ff7508 e8???????? }
            // n = 4, score = 800
            //   e8????????           |                     
            //   ffb5dcf7ffff         | push                dword ptr [ebp - 0x824]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     

        $sequence_3 = { 8bf0 e9???????? 8b4514 833800 7505 e9???????? c745fc00000000 }
            // n = 7, score = 800
            //   8bf0                 | mov                 esi, eax
            //   e9????????           |                     
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   833800               | cmp                 dword ptr [eax], 0
            //   7505                 | jne                 7
            //   e9????????           |                     
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

        $sequence_4 = { c20c00 55 8bec 81c4ecfeffff 53 ff750c }
            // n = 6, score = 800
            //   c20c00               | ret                 0xc
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81c4ecfeffff         | add                 esp, 0xfffffeec
            //   53                   | push                ebx
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_5 = { 55 8bec 83c4fc 6a00 6a06 ff7508 }
            // n = 6, score = 800
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83c4fc               | add                 esp, -4
            //   6a00                 | push                0
            //   6a06                 | push                6
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_6 = { ff7510 e8???????? 8d45dc 50 8d45e0 50 8d45e4 }
            // n = 7, score = 800
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   e8????????           |                     
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   8d45e4               | lea                 eax, [ebp - 0x1c]

        $sequence_7 = { ff7514 ff7510 ff7508 e8???????? 8bf8 837dfc00 7423 }
            // n = 7, score = 800
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7423                 | je                  0x25

        $sequence_8 = { 8d8c0f8e4379a6 034e38 c1c111 03ca 8bfa }
            // n = 5, score = 800
            //   8d8c0f8e4379a6       | lea                 ecx, [edi + ecx - 0x5986bc72]
            //   034e38               | add                 ecx, dword ptr [esi + 0x38]
            //   c1c111               | rol                 ecx, 0x11
            //   03ca                 | add                 ecx, edx
            //   8bfa                 | mov                 edi, edx

        $sequence_9 = { c9 c20400 55 8bec 83c4f4 57 8b4514 }
            // n = 7, score = 800
            //   c9                   | leave               
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83c4f4               | add                 esp, -0xc
            //   57                   | push                edi
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]

    condition:
        7 of them and filesize < 262144
}