rule win_predator_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.predator."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.predator"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89560c 834dfcff 8b4df4 64890d00000000 5f }
            // n = 5, score = 800
            //   89560c               | mov                 dword ptr [esi + 0xc], edx
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   5f                   | pop                 edi

        $sequence_1 = { 56 8bf1 8d4dfd 57 6a0a }
            // n = 5, score = 800
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   8d4dfd               | lea                 ecx, [ebp - 3]
            //   57                   | push                edi
            //   6a0a                 | push                0xa

        $sequence_2 = { 83ec18 8bc2 56 8bf1 8d4dfd 57 }
            // n = 6, score = 800
            //   83ec18               | sub                 esp, 0x18
            //   8bc2                 | mov                 eax, edx
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   8d4dfd               | lea                 ecx, [ebp - 3]
            //   57                   | push                edi

        $sequence_3 = { 83c8ff e9???????? ff75ec e8???????? 59 8bf0 }
            // n = 6, score = 800
            //   83c8ff               | or                  eax, 0xffffffff
            //   e9????????           |                     
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8bf0                 | mov                 esi, eax

        $sequence_4 = { 8b00 57 03c2 8bce 50 }
            // n = 5, score = 800
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   57                   | push                edi
            //   03c2                 | add                 eax, edx
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax

        $sequence_5 = { 8d45fd 50 51 8bce }
            // n = 4, score = 800
            //   8d45fd               | lea                 eax, [ebp - 3]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi

        $sequence_6 = { e9???????? ff75ec e8???????? 59 8bf0 }
            // n = 5, score = 800
            //   e9????????           |                     
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8bf0                 | mov                 esi, eax

        $sequence_7 = { 0f42f9 83781410 7202 8b00 57 03c2 8bce }
            // n = 7, score = 800
            //   0f42f9               | cmovb               edi, ecx
            //   83781410             | cmp                 dword ptr [eax + 0x14], 0x10
            //   7202                 | jb                  4
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   57                   | push                edi
            //   03c2                 | add                 eax, edx
            //   8bce                 | mov                 ecx, esi

        $sequence_8 = { 56 57 8965f0 8365fc00 8b7508 8b450c }
            // n = 6, score = 800
            //   56                   | push                esi
            //   57                   | push                edi
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_9 = { 8811 85c0 75f2 51 8d45fd 50 51 }
            // n = 7, score = 800
            //   8811                 | mov                 byte ptr [ecx], dl
            //   85c0                 | test                eax, eax
            //   75f2                 | jne                 0xfffffff4
            //   51                   | push                ecx
            //   8d45fd               | lea                 eax, [ebp - 3]
            //   50                   | push                eax
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 2211840
}