rule win_prestige_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.prestige."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.prestige"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 89bd60ffffff e8???????? 6a10 56 8d8d60ffffff c645fc02 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   89bd60ffffff         | mov                 dword ptr [ebp - 0xa0], edi
            //   e8????????           |                     
            //   6a10                 | push                0x10
            //   56                   | push                esi
            //   8d8d60ffffff         | lea                 ecx, [ebp - 0xa0]
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2

        $sequence_1 = { 8b7dfc 6a00 57 e8???????? eb3a 8bfe c1e702 }
            // n = 7, score = 100
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]
            //   6a00                 | push                0
            //   57                   | push                edi
            //   e8????????           |                     
            //   eb3a                 | jmp                 0x3c
            //   8bfe                 | mov                 edi, esi
            //   c1e702               | shl                 edi, 2

        $sequence_2 = { 7407 46 89b558ffffff 80bd5fffffff00 742c 8d4da0 3bc8 }
            // n = 7, score = 100
            //   7407                 | je                  9
            //   46                   | inc                 esi
            //   89b558ffffff         | mov                 dword ptr [ebp - 0xa8], esi
            //   80bd5fffffff00       | cmp                 byte ptr [ebp - 0xa1], 0
            //   742c                 | je                  0x2e
            //   8d4da0               | lea                 ecx, [ebp - 0x60]
            //   3bc8                 | cmp                 ecx, eax

        $sequence_3 = { 50 6a01 8d4508 0f57c0 50 8d45fc 660f1345f4 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   6a01                 | push                1
            //   8d4508               | lea                 eax, [ebp + 8]
            //   0f57c0               | xorps               xmm0, xmm0
            //   50                   | push                eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   660f1345f4           | movlpd              qword ptr [ebp - 0xc], xmm0

        $sequence_4 = { 0f8406feffff 8ac2 0430 8806 894df0 33c9 }
            // n = 6, score = 100
            //   0f8406feffff         | je                  0xfffffe0c
            //   8ac2                 | mov                 al, dl
            //   0430                 | add                 al, 0x30
            //   8806                 | mov                 byte ptr [esi], al
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   33c9                 | xor                 ecx, ecx

        $sequence_5 = { eb0b 88855fffffff 6a02 58 8bc8 51 ff7310 }
            // n = 7, score = 100
            //   eb0b                 | jmp                 0xd
            //   88855fffffff         | mov                 byte ptr [ebp - 0xa1], al
            //   6a02                 | push                2
            //   58                   | pop                 eax
            //   8bc8                 | mov                 ecx, eax
            //   51                   | push                ecx
            //   ff7310               | push                dword ptr [ebx + 0x10]

        $sequence_6 = { 8b75f4 8b55fc 3bde 7315 8bc2 33d2 6a0a }
            // n = 7, score = 100
            //   8b75f4               | mov                 esi, dword ptr [ebp - 0xc]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   3bde                 | cmp                 ebx, esi
            //   7315                 | jae                 0x17
            //   8bc2                 | mov                 eax, edx
            //   33d2                 | xor                 edx, edx
            //   6a0a                 | push                0xa

        $sequence_7 = { e8???????? 51 68???????? 8d8de8f5ffff c645fc56 e8???????? 51 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   51                   | push                ecx
            //   68????????           |                     
            //   8d8de8f5ffff         | lea                 ecx, [ebp - 0xa18]
            //   c645fc56             | mov                 byte ptr [ebp - 4], 0x56
            //   e8????????           |                     
            //   51                   | push                ecx

        $sequence_8 = { 83e03f 6bc038 8955f0 8b1495480a4b00 8945f8 8a5c0229 80fb02 }
            // n = 7, score = 100
            //   83e03f               | and                 eax, 0x3f
            //   6bc038               | imul                eax, eax, 0x38
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   8b1495480a4b00       | mov                 edx, dword ptr [edx*4 + 0x4b0a48]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8a5c0229             | mov                 bl, byte ptr [edx + eax + 0x29]
            //   80fb02               | cmp                 bl, 2

        $sequence_9 = { e9???????? 8b4d08 8d45f0 50 c745f054334700 c745f40e000000 }
            // n = 6, score = 100
            //   e9????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   c745f054334700       | mov                 dword ptr [ebp - 0x10], 0x473354
            //   c745f40e000000       | mov                 dword ptr [ebp - 0xc], 0xe

    condition:
        7 of them and filesize < 1518592
}