rule win_putabmow_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.putabmow."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.putabmow"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fbec2 897dc0 8d0448 83c0d0 8945d8 }
            // n = 5, score = 100
            //   0fbec2               | movsx               eax, dl
            //   897dc0               | mov                 dword ptr [ebp - 0x40], edi
            //   8d0448               | lea                 eax, [eax + ecx*2]
            //   83c0d0               | add                 eax, -0x30
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax

        $sequence_1 = { 7509 8b4c240c e8???????? c7442420ffffffff 8b4c240c 8b01 8b4004 }
            // n = 7, score = 100
            //   7509                 | jne                 0xb
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   e8????????           |                     
            //   c7442420ffffffff     | mov                 dword ptr [esp + 0x20], 0xffffffff
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]

        $sequence_2 = { ba02000000 8bcf e8???????? 8b4df4 e9???????? 837b1802 0f8538010000 }
            // n = 7, score = 100
            //   ba02000000           | mov                 edx, 2
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   e9????????           |                     
            //   837b1802             | cmp                 dword ptr [ebx + 0x18], 2
            //   0f8538010000         | jne                 0x13e

        $sequence_3 = { c745ec0f000000 c745e800000000 c645d800 c745fc03000000 8d45d8 8bce 50 }
            // n = 7, score = 100
            //   c745ec0f000000       | mov                 dword ptr [ebp - 0x14], 0xf
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   c645d800             | mov                 byte ptr [ebp - 0x28], 0
            //   c745fc03000000       | mov                 dword ptr [ebp - 4], 3
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax

        $sequence_4 = { c600e9 8b06 8b8e4c010000 5e 5b 89540101 b801000000 }
            // n = 7, score = 100
            //   c600e9               | mov                 byte ptr [eax], 0xe9
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8b8e4c010000         | mov                 ecx, dword ptr [esi + 0x14c]
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   89540101             | mov                 dword ptr [ecx + eax + 1], edx
            //   b801000000           | mov                 eax, 1

        $sequence_5 = { 895dfc 85f6 7464 8b450c 8b08 85c9 }
            // n = 6, score = 100
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   85f6                 | test                esi, esi
            //   7464                 | je                  0x66
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   85c9                 | test                ecx, ecx

        $sequence_6 = { 7fcf 47 0fbec0 8d0c89 897dc0 8d49e8 }
            // n = 6, score = 100
            //   7fcf                 | jg                  0xffffffd1
            //   47                   | inc                 edi
            //   0fbec0               | movsx               eax, al
            //   8d0c89               | lea                 ecx, [ecx + ecx*4]
            //   897dc0               | mov                 dword ptr [ebp - 0x40], edi
            //   8d49e8               | lea                 ecx, [ecx - 0x18]

        $sequence_7 = { 83c408 a3???????? 53 57 ffd0 8b4df4 64890d00000000 }
            // n = 7, score = 100
            //   83c408               | add                 esp, 8
            //   a3????????           |                     
            //   53                   | push                ebx
            //   57                   | push                edi
            //   ffd0                 | call                eax
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx

        $sequence_8 = { c7462c00000000 c7463000000000 c645fc01 8b461c 85c0 }
            // n = 5, score = 100
            //   c7462c00000000       | mov                 dword ptr [esi + 0x2c], 0
            //   c7463000000000       | mov                 dword ptr [esi + 0x30], 0
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   8b461c               | mov                 eax, dword ptr [esi + 0x1c]
            //   85c0                 | test                eax, eax

        $sequence_9 = { eb02 8bc6 8a0458 43 8ac8 }
            // n = 5, score = 100
            //   eb02                 | jmp                 4
            //   8bc6                 | mov                 eax, esi
            //   8a0458               | mov                 al, byte ptr [eax + ebx*2]
            //   43                   | inc                 ebx
            //   8ac8                 | mov                 cl, al

    condition:
        7 of them and filesize < 704512
}