rule win_qhost_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.qhost."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.qhost"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7529 83bd6cffffff01 7520 8b55f8 81e2ffff0000 }
            // n = 5, score = 100
            //   7529                 | jne                 0x2b
            //   83bd6cffffff01       | cmp                 dword ptr [ebp - 0x94], 1
            //   7520                 | jne                 0x22
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   81e2ffff0000         | and                 edx, 0xffff

        $sequence_1 = { 7528 83bd6cffffff01 751f 8b45f8 25ffff0000 83f801 7512 }
            // n = 7, score = 100
            //   7528                 | jne                 0x2a
            //   83bd6cffffff01       | cmp                 dword ptr [ebp - 0x94], 1
            //   751f                 | jne                 0x21
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   25ffff0000           | and                 eax, 0xffff
            //   83f801               | cmp                 eax, 1
            //   7512                 | jne                 0x14

        $sequence_2 = { e8???????? 50 8b8de0fdffff 51 e8???????? 83c408 8985ecfdffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   50                   | push                eax
            //   8b8de0fdffff         | mov                 ecx, dword ptr [ebp - 0x220]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8985ecfdffff         | mov                 dword ptr [ebp - 0x214], eax

        $sequence_3 = { 8b4d08 51 e8???????? 83c418 8945fc eb30 837d1807 }
            // n = 7, score = 100
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   eb30                 | jmp                 0x32
            //   837d1807             | cmp                 dword ptr [ebp + 0x18], 7

        $sequence_4 = { 8b55f4 c682????????0a ebd5 8b45fc 50 ff15???????? }
            // n = 6, score = 100
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   c682????????0a       |                     
            //   ebd5                 | jmp                 0xffffffd7
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_5 = { 837df800 741e 8b45fc 50 68???????? 68???????? ff15???????? }
            // n = 7, score = 100
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   741e                 | je                  0x20
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax
            //   68????????           |                     
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_6 = { 33c0 837d1801 0f94c0 8885c4f9ffff }
            // n = 4, score = 100
            //   33c0                 | xor                 eax, eax
            //   837d1801             | cmp                 dword ptr [ebp + 0x18], 1
            //   0f94c0               | sete                al
            //   8885c4f9ffff         | mov                 byte ptr [ebp - 0x63c], al

        $sequence_7 = { 0f84ab000000 8d559c 52 6a00 ff15???????? }
            // n = 5, score = 100
            //   0f84ab000000         | je                  0xb1
            //   8d559c               | lea                 edx, [ebp - 0x64]
            //   52                   | push                edx
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_8 = { 398da0f4ffff 0f8f84000000 8b95a0f4ffff 89959cf4ffff 8b85a0f4ffff 0500040000 }
            // n = 6, score = 100
            //   398da0f4ffff         | cmp                 dword ptr [ebp - 0xb60], ecx
            //   0f8f84000000         | jg                  0x8a
            //   8b95a0f4ffff         | mov                 edx, dword ptr [ebp - 0xb60]
            //   89959cf4ffff         | mov                 dword ptr [ebp - 0xb64], edx
            //   8b85a0f4ffff         | mov                 eax, dword ptr [ebp - 0xb60]
            //   0500040000           | add                 eax, 0x400

        $sequence_9 = { 7407 c745fcffffffff 8b45fc 8be5 5d }
            // n = 5, score = 100
            //   7407                 | je                  9
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp

    condition:
        7 of them and filesize < 286720
}