rule win_quantloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.quantloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.quantloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48 89442408 c744240401000000 c70424???????? }
            // n = 4, score = 500
            //   48                   | dec                 eax
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   c744240401000000     | mov                 dword ptr [esp + 4], 1
            //   c70424????????       |                     

        $sequence_1 = { 83ec18 c744240800040000 c744240400000000 c70424???????? e8???????? c7442404???????? }
            // n = 6, score = 500
            //   83ec18               | sub                 esp, 0x18
            //   c744240800040000     | mov                 dword ptr [esp + 8], 0x400
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   c70424????????       |                     
            //   e8????????           |                     
            //   c7442404????????     |                     

        $sequence_2 = { e8???????? 89c2 c744241000000000 8d45fc }
            // n = 4, score = 500
            //   e8????????           |                     
            //   89c2                 | mov                 edx, eax
            //   c744241000000000     | mov                 dword ptr [esp + 0x10], 0
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_3 = { 8d45f8 89442410 c744240c19010200 c744240800000000 8b450c 89442404 }
            // n = 6, score = 500
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   c744240c19010200     | mov                 dword ptr [esp + 0xc], 0x20119
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   89442404             | mov                 dword ptr [esp + 4], eax

        $sequence_4 = { c70424???????? e8???????? ff05???????? 0fb645fb 83f801 7546 }
            // n = 6, score = 500
            //   c70424????????       |                     
            //   e8????????           |                     
            //   ff05????????         |                     
            //   0fb645fb             | movzx               eax, byte ptr [ebp - 5]
            //   83f801               | cmp                 eax, 1
            //   7546                 | jne                 0x48

        $sequence_5 = { c70424???????? e8???????? e8???????? 89442404 c70424???????? e8???????? c7442404???????? }
            // n = 7, score = 500
            //   c70424????????       |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   c70424????????       |                     
            //   e8????????           |                     
            //   c7442404????????     |                     

        $sequence_6 = { 83ec18 8b4510 8845ff c745f800020000 }
            // n = 4, score = 500
            //   83ec18               | sub                 esp, 0x18
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8845ff               | mov                 byte ptr [ebp - 1], al
            //   c745f800020000       | mov                 dword ptr [ebp - 8], 0x200

        $sequence_7 = { c70424???????? e8???????? c70424???????? e8???????? 0fb6c0 83f801 }
            // n = 6, score = 500
            //   c70424????????       |                     
            //   e8????????           |                     
            //   c70424????????       |                     
            //   e8????????           |                     
            //   0fb6c0               | movzx               eax, al
            //   83f801               | cmp                 eax, 1

        $sequence_8 = { 8bfe ad 85c0 75fb 2bf7 8bce }
            // n = 6, score = 100
            //   8bfe                 | mov                 edi, esi
            //   ad                   | lodsd               eax, dword ptr [esi]
            //   85c0                 | test                eax, eax
            //   75fb                 | jne                 0xfffffffd
            //   2bf7                 | sub                 esi, edi
            //   8bce                 | mov                 ecx, esi

        $sequence_9 = { 5f 5e 5b ebed 61 }
            // n = 5, score = 100
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   ebed                 | jmp                 0xffffffef
            //   61                   | popal               

        $sequence_10 = { 60 837d5400 7425 64ff3530000000 59 8b490c 8b490c }
            // n = 7, score = 100
            //   60                   | pushal              
            //   837d5400             | cmp                 dword ptr [ebp + 0x54], 0
            //   7425                 | je                  0x27
            //   64ff3530000000       | push                dword ptr fs:[0x30]
            //   59                   | pop                 ecx
            //   8b490c               | mov                 ecx, dword ptr [ecx + 0xc]
            //   8b490c               | mov                 ecx, dword ptr [ecx + 0xc]

        $sequence_11 = { 51 33c9 41 2bc2 }
            // n = 4, score = 100
            //   51                   | push                ecx
            //   33c9                 | xor                 ecx, ecx
            //   41                   | inc                 ecx
            //   2bc2                 | sub                 eax, edx

        $sequence_12 = { 8bc6 8bf7 3bc5 7403 }
            // n = 4, score = 100
            //   8bc6                 | mov                 eax, esi
            //   8bf7                 | mov                 esi, edi
            //   3bc5                 | cmp                 eax, ebp
            //   7403                 | je                  5

        $sequence_13 = { ab 83e903 e2db 61 }
            // n = 4, score = 100
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   83e903               | sub                 ecx, 3
            //   e2db                 | loop                0xffffffdd
            //   61                   | popal               

        $sequence_14 = { 8bfe 8bca e8???????? 33c0 50 c1c807 c104240d }
            // n = 7, score = 100
            //   8bfe                 | mov                 edi, esi
            //   8bca                 | mov                 ecx, edx
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   50                   | push                eax
            //   c1c807               | ror                 eax, 7
            //   c104240d             | rol                 dword ptr [esp], 0xd

        $sequence_15 = { 39411c 74f7 ff711c 8f4550 e8???????? 8f411c }
            // n = 6, score = 100
            //   39411c               | cmp                 dword ptr [ecx + 0x1c], eax
            //   74f7                 | je                  0xfffffff9
            //   ff711c               | push                dword ptr [ecx + 0x1c]
            //   8f4550               | pop                 dword ptr [ebp + 0x50]
            //   e8????????           |                     
            //   8f411c               | pop                 dword ptr [ecx + 0x1c]

    condition:
        7 of them and filesize < 155648
}