rule win_quickheal_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.quickheal."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.quickheal"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8819 885101 83c102 3bc6 7cf0 5f }
            // n = 6, score = 100
            //   8819                 | mov                 byte ptr [ecx], bl
            //   885101               | mov                 byte ptr [ecx + 1], dl
            //   83c102               | add                 ecx, 2
            //   3bc6                 | cmp                 eax, esi
            //   7cf0                 | jl                  0xfffffff2
            //   5f                   | pop                 edi

        $sequence_1 = { 8d94248c040000 6804010000 51 6aff 52 53 53 }
            // n = 7, score = 100
            //   8d94248c040000       | lea                 edx, [esp + 0x48c]
            //   6804010000           | push                0x104
            //   51                   | push                ecx
            //   6aff                 | push                -1
            //   52                   | push                edx
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_2 = { 8bc3 c1e817 c1e309 0bc3 8bd8 8be8 }
            // n = 6, score = 100
            //   8bc3                 | mov                 eax, ebx
            //   c1e817               | shr                 eax, 0x17
            //   c1e309               | shl                 ebx, 9
            //   0bc3                 | or                  eax, ebx
            //   8bd8                 | mov                 ebx, eax
            //   8be8                 | mov                 ebp, eax

        $sequence_3 = { 8944242c 55 e9???????? ffd6 68???????? 57 8944243c }
            // n = 7, score = 100
            //   8944242c             | mov                 dword ptr [esp + 0x2c], eax
            //   55                   | push                ebp
            //   e9????????           |                     
            //   ffd6                 | call                esi
            //   68????????           |                     
            //   57                   | push                edi
            //   8944243c             | mov                 dword ptr [esp + 0x3c], eax

        $sequence_4 = { 8b4c2414 e8???????? 53 c705????????01000000 e8???????? 83c404 }
            // n = 6, score = 100
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   e8????????           |                     
            //   53                   | push                ebx
            //   c705????????01000000     |     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_5 = { e8???????? 83c418 e9???????? a0???????? 84c0 7555 a0???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   e9????????           |                     
            //   a0????????           |                     
            //   84c0                 | test                al, al
            //   7555                 | jne                 0x57
            //   a0????????           |                     

        $sequence_6 = { 8d5c2410 83c404 8944240c c1eb04 8d740704 e8???????? 3206 }
            // n = 7, score = 100
            //   8d5c2410             | lea                 ebx, [esp + 0x10]
            //   83c404               | add                 esp, 4
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   c1eb04               | shr                 ebx, 4
            //   8d740704             | lea                 esi, [edi + eax + 4]
            //   e8????????           |                     
            //   3206                 | xor                 al, byte ptr [esi]

        $sequence_7 = { 6aff 68???????? 6a00 6a00 ffd3 8bf8 }
            // n = 6, score = 100
            //   6aff                 | push                -1
            //   68????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ffd3                 | call                ebx
            //   8bf8                 | mov                 edi, eax

        $sequence_8 = { 85c0 0f8491fcffff 8b4c241c 51 ff15???????? }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   0f8491fcffff         | je                  0xfffffc97
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_9 = { 52 ffd7 85c0 7418 8b442410 c744241404010000 50 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   7418                 | je                  0x1a
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   c744241404010000     | mov                 dword ptr [esp + 0x14], 0x104
            //   50                   | push                eax

    condition:
        7 of them and filesize < 553984
}