rule win_r77_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.r77."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.r77"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 740b 8b0f e8???????? 85c0 }
            // n = 4, score = 200
            //   740b                 | je                  0xd
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_1 = { 740c 8b4f0c e8???????? 85c0 }
            // n = 4, score = 200
            //   740c                 | je                  0xe
            //   8b4f0c               | mov                 ecx, dword ptr [edi + 0xc]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_2 = { 660fc5c400 25f0070000 660f28a050680110 660f28b840640110 660f54f0 660f5cc6 660f59f4 }
            // n = 7, score = 100
            //   660fc5c400           | jb                  0xffffffed
            //   25f0070000           | je                  0x14
            //   660f28a050680110     | dec                 eax
            //   660f28b840640110     | lea                 edx, [0x1ad36]
            //   660f54f0             | dec                 eax
            //   660f5cc6             | mov                 ecx, eax
            //   660f59f4             | jmp                 5

        $sequence_3 = { 488b4b18 e8???????? 85c0 744b 488b5720 488b4b20 e8???????? }
            // n = 7, score = 100
            //   488b4b18             | dec                 eax
            //   e8????????           |                     
            //   85c0                 | mov                 ecx, dword ptr [ebx + 0x18]
            //   744b                 | test                eax, eax
            //   488b5720             | je                  0x4d
            //   488b4b20             | dec                 eax
            //   e8????????           |                     

        $sequence_4 = { 8b0c85f8a00110 8a0413 03ce 8844192e 43 }
            // n = 5, score = 100
            //   8b0c85f8a00110       | mov                 dword ptr [ebp + 8], eax
            //   8a0413               | cmp                 dword ptr [ebp + 0xc], 0
            //   03ce                 | jne                 0x17
            //   8844192e             | push                0xd
            //   43                   | pextrw              eax, xmm4, 0

        $sequence_5 = { 4533db 488b05???????? 4885c0 7432 488b5028 418bcb 448b02 }
            // n = 7, score = 100
            //   4533db               | mov                 edx, dword ptr [edi + 0x20]
            //   488b05????????       |                     
            //   4885c0               | dec                 eax
            //   7432                 | mov                 ecx, dword ptr [ebx + 0x20]
            //   488b5028             | inc                 ebp
            //   418bcb               | xor                 ebx, ebx
            //   448b02               | dec                 eax

        $sequence_6 = { 488bc8 ff15???????? 85c0 740e 395c2440 0f94c3 }
            // n = 6, score = 100
            //   488bc8               | mov                 ecx, ebx
            //   ff15????????         |                     
            //   85c0                 | inc                 esp
            //   740e                 | mov                 eax, dword ptr [edx]
            //   395c2440             | jae                 0x59
            //   0f94c3               | dec                 ecx

        $sequence_7 = { ff7650 6a00 ffd0 8bd8 895de8 85db }
            // n = 6, score = 100
            //   ff7650               | test                eax, eax
            //   6a00                 | je                  0xd
            //   ffd0                 | mov                 ecx, dword ptr [edi]
            //   8bd8                 | test                eax, eax
            //   895de8               | mov                 eax, dword ptr [ebp - 8]
            //   85db                 | add                 eax, 0x30

        $sequence_8 = { 837f0800 7414 8b470c ff3498 8b460c ff3498 }
            // n = 6, score = 100
            //   837f0800             | dec                 ecx
            //   7414                 | mov                 eax, edi
            //   8b470c               | inc                 ecx
            //   ff3498               | mov                 ecx, 0x1f4
            //   8b460c               | je                  0xe
            //   ff3498               | mov                 ecx, dword ptr [edi + 0xc]

        $sequence_9 = { 8b45f8 83c030 894508 837d0c00 750b 6a0d e8???????? }
            // n = 7, score = 100
            //   8b45f8               | cmp                 dword ptr [edx + ecx*4], eax
            //   83c030               | jne                 0x10
            //   894508               | inc                 ecx
            //   837d0c00             | inc                 eax
            //   750b                 | inc                 ebp
            //   6a0d                 | cmp                 eax, ecx
            //   e8????????           |                     

        $sequence_10 = { 418bc8 418b048b 4139048a 750e 41ffc0 453bc1 72eb }
            // n = 7, score = 100
            //   418bc8               | dec                 ecx
            //   418b048b             | mov                 eax, eax
            //   4139048a             | dec                 eax
            //   750e                 | mov                 ecx, eax
            //   41ffc0               | test                eax, eax
            //   453bc1               | je                  0x10
            //   72eb                 | cmp                 dword ptr [esp + 0x40], ebx

        $sequence_11 = { d1e1 8b5508 0fb6040a 83f840 }
            // n = 4, score = 100
            //   d1e1                 | and                 eax, 0x7f0
            //   8b5508               | movapd              xmm4, xmmword ptr [eax + 0x10016850]
            //   0fb6040a             | movapd              xmm7, xmmword ptr [eax + 0x10016440]
            //   83f840               | andpd               xmm6, xmm0

        $sequence_12 = { 7357 498bc8 4c8d1571e80000 83e13f 498bc0 }
            // n = 5, score = 100
            //   7357                 | test                eax, eax
            //   498bc8               | je                  0x37
            //   4c8d1571e80000       | dec                 eax
            //   83e13f               | mov                 edx, dword ptr [eax + 0x28]
            //   498bc0               | inc                 ecx

        $sequence_13 = { 488b55c8 4c8d054efd0000 85c0 0f8417010000 }
            // n = 4, score = 100
            //   488b55c8             | mov                 ecx, eax
            //   4c8d054efd0000       | dec                 esp
            //   85c0                 | lea                 edx, [0xe871]
            //   0f8417010000         | and                 ecx, 0x3f

    condition:
        7 of them and filesize < 350208
}