rule win_ramdo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ramdo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ramdo"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff55f8 8945fc 837dfcff 7411 }
            // n = 4, score = 600
            //   ff55f8               | call                dword ptr [ebp - 8]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfcff             | cmp                 dword ptr [ebp - 4], -1
            //   7411                 | je                  0x13

        $sequence_1 = { 6813299e13 6a00 6a00 e8???????? }
            // n = 4, score = 600
            //   6813299e13           | push                0x139e2913
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_2 = { 55 8bec 83ec0c 68b928ece1 }
            // n = 4, score = 600
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec0c               | sub                 esp, 0xc
            //   68b928ece1           | push                0xe1ec28b9

        $sequence_3 = { 83c414 68b6b2cff5 6a03 6a00 e8???????? }
            // n = 5, score = 600
            //   83c414               | add                 esp, 0x14
            //   68b6b2cff5           | push                0xf5cfb2b6
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_4 = { 68bc882a42 6a03 6a00 e8???????? }
            // n = 4, score = 600
            //   68bc882a42           | push                0x422a88bc
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_5 = { 55 8bec 83ec0c 68b928ece1 6a03 6a00 }
            // n = 6, score = 600
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec0c               | sub                 esp, 0xc
            //   68b928ece1           | push                0xe1ec28b9
            //   6a03                 | push                3
            //   6a00                 | push                0

        $sequence_6 = { 68ce173dab 6a03 6a00 e8???????? }
            // n = 4, score = 600
            //   68ce173dab           | push                0xab3d17ce
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_7 = { 68b796c807 6a03 6a00 e8???????? }
            // n = 4, score = 600
            //   68b796c807           | push                0x7c896b7
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_8 = { 68b900308a 6a01 6a00 e8???????? }
            // n = 4, score = 600
            //   68b900308a           | push                0x8a3000b9
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_9 = { 689aa93f35 6a05 6a00 e8???????? }
            // n = 4, score = 600
            //   689aa93f35           | push                0x353fa99a
            //   6a05                 | push                5
            //   6a00                 | push                0
            //   e8????????           |                     

    condition:
        7 of them and filesize < 548864
}