rule win_ramnit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ramnit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ramnit"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5a 5b c9 c20400 55 8bec }
            // n = 6, score = 4000
            //   5a                   | pop                 edx
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_1 = { 5e 5f 59 5a }
            // n = 4, score = 4000
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   59                   | pop                 ecx
            //   5a                   | pop                 edx

        $sequence_2 = { 51 52 8b4508 8b5d0c 4b f7d3 23c3 }
            // n = 7, score = 4000
            //   51                   | push                ecx
            //   52                   | push                edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]
            //   4b                   | dec                 ebx
            //   f7d3                 | not                 ebx
            //   23c3                 | and                 eax, ebx

        $sequence_3 = { 51 52 8b4508 8b5d0c }
            // n = 4, score = 4000
            //   51                   | push                ecx
            //   52                   | push                edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]

        $sequence_4 = { 8b7510 3b7514 7705 3b7d0c 7602 }
            // n = 5, score = 4000
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   3b7514               | cmp                 esi, dword ptr [ebp + 0x14]
            //   7705                 | ja                  7
            //   3b7d0c               | cmp                 edi, dword ptr [ebp + 0xc]
            //   7602                 | jbe                 4

        $sequence_5 = { b800000000 59 5f 5e 5a 5b c9 }
            // n = 7, score = 4000
            //   b800000000           | mov                 eax, 0
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5a                   | pop                 edx
            //   5b                   | pop                 ebx
            //   c9                   | leave               

        $sequence_6 = { 7434 837d1000 742e 837d1400 7428 }
            // n = 5, score = 4000
            //   7434                 | je                  0x36
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0
            //   742e                 | je                  0x30
            //   837d1400             | cmp                 dword ptr [ebp + 0x14], 0
            //   7428                 | je                  0x2a

        $sequence_7 = { 8bec 8b4508 3b450c 7603 8b450c c9 c20800 }
            // n = 7, score = 4000
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   3b450c               | cmp                 eax, dword ptr [ebp + 0xc]
            //   7603                 | jbe                 5
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   c9                   | leave               
            //   c20800               | ret                 8

        $sequence_8 = { f7d0 48 59 5f }
            // n = 4, score = 4000
            //   f7d0                 | not                 eax
            //   48                   | dec                 eax
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi

        $sequence_9 = { 7512 47 46 e2f6 b801000000 59 }
            // n = 6, score = 4000
            //   7512                 | jne                 0x14
            //   47                   | inc                 edi
            //   46                   | inc                 esi
            //   e2f6                 | loop                0xfffffff8
            //   b801000000           | mov                 eax, 1
            //   59                   | pop                 ecx

    condition:
        7 of them and filesize < 470016
}