rule win_ratel_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ratel."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ratel"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8944240c 8b4584 c744240800000000 89442404 8d45b2 890424 e8???????? }
            // n = 7, score = 100
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   8b4584               | mov                 eax, dword ptr [ebp - 0x7c]
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   8d45b2               | lea                 eax, [ebp - 0x4e]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_1 = { 31ff 8db42600000000 6690 0fb701 89fd 83e902 89c7 }
            // n = 7, score = 100
            //   31ff                 | xor                 edi, edi
            //   8db42600000000       | lea                 esi, [esi]
            //   6690                 | nop                 
            //   0fb701               | movzx               eax, word ptr [ecx]
            //   89fd                 | mov                 ebp, edi
            //   83e902               | sub                 ecx, 2
            //   89c7                 | mov                 edi, eax

        $sequence_2 = { 8b4508 31db 66891e 8b7508 8b00 8b50f4 }
            // n = 6, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   31db                 | xor                 ebx, ebx
            //   66891e               | mov                 word ptr [esi], bx
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b50f4               | mov                 edx, dword ptr [eax - 0xc]

        $sequence_3 = { 08d0 0f8474060000 c745c800000000 be10000000 c645cc00 8b4d08 8b4108 }
            // n = 7, score = 100
            //   08d0                 | or                  al, dl
            //   0f8474060000         | je                  0x67a
            //   c745c800000000       | mov                 dword ptr [ebp - 0x38], 0
            //   be10000000           | mov                 esi, 0x10
            //   c645cc00             | mov                 byte ptr [ebp - 0x34], 0
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b4108               | mov                 eax, dword ptr [ecx + 8]

        $sequence_4 = { 8b4c2454 89442418 8d842418010000 89442414 8b842480010000 896c2404 89442410 }
            // n = 7, score = 100
            //   8b4c2454             | mov                 ecx, dword ptr [esp + 0x54]
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   8d842418010000       | lea                 eax, [esp + 0x118]
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   8b842480010000       | mov                 eax, dword ptr [esp + 0x180]
            //   896c2404             | mov                 dword ptr [esp + 4], ebp
            //   89442410             | mov                 dword ptr [esp + 0x10], eax

        $sequence_5 = { e9???????? 8d4510 8d4d08 bf10000000 890424 8945d0 e8???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d4510               | lea                 eax, [ebp + 0x10]
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   bf10000000           | mov                 edi, 0x10
            //   890424               | mov                 dword ptr [esp], eax
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   e8????????           |                     

        $sequence_6 = { 8b03 8b5508 837d1401 8d0450 0f84b4000000 8b5514 8b7510 }
            // n = 7, score = 100
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   837d1401             | cmp                 dword ptr [ebp + 0x14], 1
            //   8d0450               | lea                 eax, [eax + edx*2]
            //   0f84b4000000         | je                  0xba
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]

        $sequence_7 = { f7d1 0fafc7 39c1 0f92c1 084dc3 8b4d08 01d0 }
            // n = 7, score = 100
            //   f7d1                 | not                 ecx
            //   0fafc7               | imul                eax, edi
            //   39c1                 | cmp                 ecx, eax
            //   0f92c1               | setb                cl
            //   084dc3               | or                  byte ptr [ebp - 0x3d], cl
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   01d0                 | add                 eax, edx

        $sequence_8 = { 8d8584feffff c7442408ffffffff 8d8d74ffffff c744240408000000 890424 e8???????? 83ec0c }
            // n = 7, score = 100
            //   8d8584feffff         | lea                 eax, [ebp - 0x17c]
            //   c7442408ffffffff     | mov                 dword ptr [esp + 8], 0xffffffff
            //   8d8d74ffffff         | lea                 ecx, [ebp - 0x8c]
            //   c744240408000000     | mov                 dword ptr [esp + 4], 8
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   83ec0c               | sub                 esp, 0xc

        $sequence_9 = { 8b4524 8b55b8 83ec08 8b4db4 8955a0 8b00 3b4da4 }
            // n = 7, score = 100
            //   8b4524               | mov                 eax, dword ptr [ebp + 0x24]
            //   8b55b8               | mov                 edx, dword ptr [ebp - 0x48]
            //   83ec08               | sub                 esp, 8
            //   8b4db4               | mov                 ecx, dword ptr [ebp - 0x4c]
            //   8955a0               | mov                 dword ptr [ebp - 0x60], edx
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   3b4da4               | cmp                 ecx, dword ptr [ebp - 0x5c]

    condition:
        7 of them and filesize < 2174976
}