rule win_rawdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rawdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rawdoor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 81e2ff030000 81e1ff030000 c1e10a 0bca 81c100000100 }
            // n = 5, score = 800
            //   81e2ff030000         | and                 edx, 0x3ff
            //   81e1ff030000         | and                 ecx, 0x3ff
            //   c1e10a               | shl                 ecx, 0xa
            //   0bca                 | or                  ecx, edx
            //   81c100000100         | add                 ecx, 0x10000

        $sequence_1 = { e8???????? 488bf8 488d4b14 488d542450 ff15???????? 440fb754245a 440fb75c2458 }
            // n = 7, score = 600
            //   e8????????           |                     
            //   488bf8               | inc                 eax
            //   488d4b14             | jmp                 0xb
            //   488d542450           | dec                 eax
            //   ff15????????         |                     
            //   440fb754245a         | mov                 edx, edi
            //   440fb75c2458         | jmp                 0xb

        $sequence_2 = { ff15???????? eb09 488bd7 ff15???????? }
            // n = 4, score = 600
            //   ff15????????         |                     
            //   eb09                 | mov                 byte ptr [esp + 0x23], al
            //   488bd7               | mov                 eax, ecx
            //   ff15????????         |                     

        $sequence_3 = { c1e818 452bc1 88442423 8bc1 4183e03f }
            // n = 5, score = 600
            //   c1e818               | shr                 eax, 0x18
            //   452bc1               | inc                 ebp
            //   88442423             | sub                 eax, ecx
            //   8bc1                 | mov                 byte ptr [esp + 0x23], al
            //   4183e03f             | mov                 eax, ecx

        $sequence_4 = { ff15???????? eb09 488bd3 ff15???????? b934000000 e8???????? 4889442430 }
            // n = 7, score = 600
            //   ff15????????         |                     
            //   eb09                 | inc                 ecx
            //   488bd3               | and                 eax, 0x3f
            //   ff15????????         |                     
            //   b934000000           | shr                 eax, 8
            //   e8????????           |                     
            //   4889442430           | inc                 ecx

        $sequence_5 = { e8???????? 488bf8 48894610 4885c0 0f848e000000 488bcb e8???????? }
            // n = 7, score = 600
            //   e8????????           |                     
            //   488bf8               | lea                 edx, [esp + 0x50]
            //   48894610             | inc                 esp
            //   4885c0               | movzx               edx, word ptr [esp + 0x5a]
            //   0f848e000000         | inc                 esp
            //   488bcb               | movzx               ebx, word ptr [esp + 0x58]
            //   e8????????           |                     

        $sequence_6 = { e8???????? 488bf8 4889442430 4885ed 745f 33d2 488bcd }
            // n = 7, score = 600
            //   e8????????           |                     
            //   488bf8               | mov                 edi, eax
            //   4889442430           | dec                 eax
            //   4885ed               | lea                 ecx, [ebx + 0x14]
            //   745f                 | dec                 eax
            //   33d2                 | lea                 edx, [esp + 0x50]
            //   488bcd               | dec                 eax

        $sequence_7 = { c1e906 894c2448 80e13f 48ffcb }
            // n = 4, score = 600
            //   c1e906               | mov                 edi, eax
            //   894c2448             | dec                 eax
            //   80e13f               | lea                 ecx, [ebx + 0x14]
            //   48ffcb               | dec                 eax

        $sequence_8 = { 0000 0001 0100 0001 }
            // n = 4, score = 400
            //   0000                 | shl                 ecx, 0xa
            //   0001                 | or                  ecx, edx
            //   0100                 | and                 ecx, 0x3ff
            //   0001                 | shl                 ecx, 0xa

        $sequence_9 = { 0101 0100 0000 0001 }
            // n = 4, score = 400
            //   0101                 | shl                 ecx, 0xa
            //   0100                 | or                  ecx, edx
            //   0000                 | and                 ecx, 0x3ff
            //   0001                 | shl                 ecx, 0xa

        $sequence_10 = { 0304b540150310 59 5e eb05 }
            // n = 4, score = 200
            //   0304b540150310       | add                 dword ptr [ecx], eax
            //   59                   | add                 dword ptr [eax], eax
            //   5e                   | add                 byte ptr [eax], al
            //   eb05                 | add                 byte ptr [ecx], al

        $sequence_11 = { 030c8540150310 eb05 b9???????? f6410420 }
            // n = 4, score = 200
            //   030c8540150310       | pop                 esi
            //   eb05                 | jmp                 9
            //   b9????????           |                     
            //   f6410420             | add                 eax, dword ptr [esi*4 + 0x10031540]

        $sequence_12 = { 030c8540150310 eb02 8bcb f6412480 }
            // n = 4, score = 200
            //   030c8540150310       | add                 dword ptr [eax], eax
            //   eb02                 | add                 byte ptr [ecx], al
            //   8bcb                 | add                 dword ptr [ecx], eax
            //   f6412480             | add                 dword ptr [ecx], eax

        $sequence_13 = { 03048d40150310 eb05 b8???????? f640247f 7529 83faff }
            // n = 6, score = 200
            //   03048d40150310       | add                 byte ptr [ecx], al
            //   eb05                 | add                 dword ptr [eax], eax
            //   b8????????           |                     
            //   f640247f             | add                 byte ptr [ecx], al
            //   7529                 | add                 dword ptr [ecx], eax
            //   83faff               | add                 dword ptr [eax], eax

        $sequence_14 = { 030c8540150310 eb02 8bce f6412480 }
            // n = 4, score = 200
            //   030c8540150310       | add                 dword ptr [ecx], eax
            //   eb02                 | add                 dword ptr [ecx], eax
            //   8bce                 | add                 dword ptr [ecx], eax
            //   f6412480             | add                 eax, dword ptr [ecx*4 + 0x10031540]

    condition:
        7 of them and filesize < 445440
}