rule win_rctrl_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rctrl."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rctrl"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff75a4 8b4104 8d4dec 51 ff7004 ff15???????? c745a028535700 }
            // n = 7, score = 100
            //   ff75a4               | push                dword ptr [ebp - 0x5c]
            //   8b4104               | mov                 eax, dword ptr [ecx + 4]
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   51                   | push                ecx
            //   ff7004               | push                dword ptr [eax + 4]
            //   ff15????????         |                     
            //   c745a028535700       | mov                 dword ptr [ebp - 0x60], 0x575328

        $sequence_1 = { 8b0495c8215d00 f644082801 7421 57 e8???????? 59 50 }
            // n = 7, score = 100
            //   8b0495c8215d00       | mov                 eax, dword ptr [edx*4 + 0x5d21c8]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7421                 | je                  0x23
            //   57                   | push                edi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   50                   | push                eax

        $sequence_2 = { 8d842454100000 660f13442418 660f13442410 50 660f13442444 ff15???????? 83e802 }
            // n = 7, score = 100
            //   8d842454100000       | lea                 eax, [esp + 0x1054]
            //   660f13442418         | movlpd              qword ptr [esp + 0x18], xmm0
            //   660f13442410         | movlpd              qword ptr [esp + 0x10], xmm0
            //   50                   | push                eax
            //   660f13442444         | movlpd              qword ptr [esp + 0x44], xmm0
            //   ff15????????         |                     
            //   83e802               | sub                 eax, 2

        $sequence_3 = { 0f85d2000000 8b45b8 85c0 0f85d6020000 0fb64b72 0fb64371 81c900020000 }
            // n = 7, score = 100
            //   0f85d2000000         | jne                 0xd8
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]
            //   85c0                 | test                eax, eax
            //   0f85d6020000         | jne                 0x2dc
            //   0fb64b72             | movzx               ecx, byte ptr [ebx + 0x72]
            //   0fb64371             | movzx               eax, byte ptr [ebx + 0x71]
            //   81c900020000         | or                  ecx, 0x200

        $sequence_4 = { e8???????? 59 895f34 395f40 740c ff7740 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   895f34               | mov                 dword ptr [edi + 0x34], ebx
            //   395f40               | cmp                 dword ptr [edi + 0x40], ebx
            //   740c                 | je                  0xe
            //   ff7740               | push                dword ptr [edi + 0x40]

        $sequence_5 = { 56 e8???????? 59 898530fcffff c645fc01 85c0 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   898530fcffff         | mov                 dword ptr [ebp - 0x3d0], eax
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   85c0                 | test                eax, eax

        $sequence_6 = { 8985c8f6ffff 0f852cfcffff 8b95b4f6ffff 85d2 0f843d010000 8b0495b4155a00 8985ccf6ffff }
            // n = 7, score = 100
            //   8985c8f6ffff         | mov                 dword ptr [ebp - 0x938], eax
            //   0f852cfcffff         | jne                 0xfffffc32
            //   8b95b4f6ffff         | mov                 edx, dword ptr [ebp - 0x94c]
            //   85d2                 | test                edx, edx
            //   0f843d010000         | je                  0x143
            //   8b0495b4155a00       | mov                 eax, dword ptr [edx*4 + 0x5a15b4]
            //   8985ccf6ffff         | mov                 dword ptr [ebp - 0x934], eax

        $sequence_7 = { 33db 57 391e 7438 68???????? ff15???????? }
            // n = 6, score = 100
            //   33db                 | xor                 ebx, ebx
            //   57                   | push                edi
            //   391e                 | cmp                 dword ptr [esi], ebx
            //   7438                 | je                  0x3a
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_8 = { 8d85ece7ffff 6a00 50 68ff030000 8d85fcfbffff 50 ff734c }
            // n = 7, score = 100
            //   8d85ece7ffff         | lea                 eax, [ebp - 0x1814]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   68ff030000           | push                0x3ff
            //   8d85fcfbffff         | lea                 eax, [ebp - 0x404]
            //   50                   | push                eax
            //   ff734c               | push                dword ptr [ebx + 0x4c]

        $sequence_9 = { 50 8d4dc8 e8???????? 85c0 0f84c5070000 895dac c745a870535700 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f84c5070000         | je                  0x7cb
            //   895dac               | mov                 dword ptr [ebp - 0x54], ebx
            //   c745a870535700       | mov                 dword ptr [ebp - 0x58], 0x575370

    condition:
        7 of them and filesize < 4315136
}