rule win_redpepper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.redpepper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.redpepper"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 40 50 eb03 50 }
            // n = 4, score = 300
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   eb03                 | jmp                 5
            //   50                   | push                eax

        $sequence_1 = { 741e 8b4050 6800400000 50 }
            // n = 4, score = 300
            //   741e                 | je                  0x20
            //   8b4050               | mov                 eax, dword ptr [eax + 0x50]
            //   6800400000           | push                0x4000
            //   50                   | push                eax

        $sequence_2 = { 3bf0 7ce1 68???????? e8???????? c70424???????? e8???????? c70424???????? }
            // n = 7, score = 300
            //   3bf0                 | cmp                 esi, eax
            //   7ce1                 | jl                  0xffffffe3
            //   68????????           |                     
            //   e8????????           |                     
            //   c70424????????       |                     
            //   e8????????           |                     
            //   c70424????????       |                     

        $sequence_3 = { 85c0 741e 8b442428 50 68???????? 6a02 }
            // n = 6, score = 300
            //   85c0                 | test                eax, eax
            //   741e                 | je                  0x20
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   50                   | push                eax
            //   68????????           |                     
            //   6a02                 | push                2

        $sequence_4 = { 85f6 745a 8b4604 8b7c2420 8b5c2414 85c0 }
            // n = 6, score = 300
            //   85f6                 | test                esi, esi
            //   745a                 | je                  0x5c
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   8b7c2420             | mov                 edi, dword ptr [esp + 0x20]
            //   8b5c2414             | mov                 ebx, dword ptr [esp + 0x14]
            //   85c0                 | test                eax, eax

        $sequence_5 = { 56 e8???????? 83c404 c7472000000000 c7471400000000 }
            // n = 5, score = 300
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c7472000000000       | mov                 dword ptr [edi + 0x20], 0
            //   c7471400000000       | mov                 dword ptr [edi + 0x14], 0

        $sequence_6 = { 7522 6893020000 68???????? 6a3a 6883000000 }
            // n = 5, score = 300
            //   7522                 | jne                 0x24
            //   6893020000           | push                0x293
            //   68????????           |                     
            //   6a3a                 | push                0x3a
            //   6883000000           | push                0x83

        $sequence_7 = { 7f0c 0fbec9 c1e006 8d4408bf eb4e }
            // n = 5, score = 300
            //   7f0c                 | jg                  0xe
            //   0fbec9               | movsx               ecx, cl
            //   c1e006               | shl                 eax, 6
            //   8d4408bf             | lea                 eax, [eax + ecx - 0x41]
            //   eb4e                 | jmp                 0x50

        $sequence_8 = { 894610 89462c 8d4638 896e04 50 }
            // n = 5, score = 300
            //   894610               | mov                 dword ptr [esi + 0x10], eax
            //   89462c               | mov                 dword ptr [esi + 0x2c], eax
            //   8d4638               | lea                 eax, [esi + 0x38]
            //   896e04               | mov                 dword ptr [esi + 4], ebp
            //   50                   | push                eax

        $sequence_9 = { 56 56 c705????????01000000 ff15???????? 50 ff15???????? }
            // n = 6, score = 300
            //   56                   | push                esi
            //   56                   | push                esi
            //   c705????????01000000     |     
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 2482176
}