rule win_regin_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.regin."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.regin"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3ac3 7456 44 8b842498000000 8bd7 48 8bbc2488000000 }
            // n = 7, score = 100
            //   3ac3                 | cmp                 al, bl
            //   7456                 | je                  0x58
            //   44                   | inc                 esp
            //   8b842498000000       | mov                 eax, dword ptr [esp + 0x98]
            //   8bd7                 | mov                 edx, edi
            //   48                   | dec                 eax
            //   8bbc2488000000       | mov                 edi, dword ptr [esp + 0x88]

        $sequence_1 = { 0f84e8000000 33ff 33f6 8b0d???????? 3bf9 }
            // n = 5, score = 100
            //   0f84e8000000         | je                  0xee
            //   33ff                 | xor                 edi, edi
            //   33f6                 | xor                 esi, esi
            //   8b0d????????         |                     
            //   3bf9                 | cmp                 edi, ecx

        $sequence_2 = { 8d4804 e8???????? 85c0 751a 48 8b0d???????? 83caff }
            // n = 7, score = 100
            //   8d4804               | lea                 ecx, [eax + 4]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   751a                 | jne                 0x1c
            //   48                   | dec                 eax
            //   8b0d????????         |                     
            //   83caff               | or                  edx, 0xffffffff

        $sequence_3 = { 7438 3de8000000 7431 b9f4010000 }
            // n = 4, score = 100
            //   7438                 | je                  0x3a
            //   3de8000000           | cmp                 eax, 0xe8
            //   7431                 | je                  0x33
            //   b9f4010000           | mov                 ecx, 0x1f4

        $sequence_4 = { 44 0f45f8 e8???????? 3ac3 7456 }
            // n = 5, score = 100
            //   44                   | inc                 esp
            //   0f45f8               | cmovne              edi, eax
            //   e8????????           |                     
            //   3ac3                 | cmp                 al, bl
            //   7456                 | je                  0x58

        $sequence_5 = { e8???????? eb0b 44 3beb }
            // n = 4, score = 100
            //   e8????????           |                     
            //   eb0b                 | jmp                 0xd
            //   44                   | inc                 esp
            //   3beb                 | cmp                 ebp, ebx

        $sequence_6 = { 4c 8be7 48 8978c0 8978c8 48 }
            // n = 6, score = 100
            //   4c                   | dec                 esp
            //   8be7                 | mov                 esp, edi
            //   48                   | dec                 eax
            //   8978c0               | mov                 dword ptr [eax - 0x40], edi
            //   8978c8               | mov                 dword ptr [eax - 0x38], edi
            //   48                   | dec                 eax

        $sequence_7 = { 897c2420 ff15???????? 48 3bc7 48 }
            // n = 5, score = 100
            //   897c2420             | mov                 dword ptr [esp + 0x20], edi
            //   ff15????????         |                     
            //   48                   | dec                 eax
            //   3bc7                 | cmp                 eax, edi
            //   48                   | dec                 eax

        $sequence_8 = { 895c2440 e8???????? 3ac3 7434 48 }
            // n = 5, score = 100
            //   895c2440             | mov                 dword ptr [esp + 0x40], ebx
            //   e8????????           |                     
            //   3ac3                 | cmp                 al, bl
            //   7434                 | je                  0x36
            //   48                   | dec                 eax

        $sequence_9 = { 750d 48 8d0dff000000 ff15???????? 48 8d152a030000 48 }
            // n = 7, score = 100
            //   750d                 | jne                 0xf
            //   48                   | dec                 eax
            //   8d0dff000000         | lea                 ecx, [0xff]
            //   ff15????????         |                     
            //   48                   | dec                 eax
            //   8d152a030000         | lea                 edx, [0x32a]
            //   48                   | dec                 eax

    condition:
        7 of them and filesize < 49152
}