rule win_regretlocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.regretlocker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.regretlocker"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8bc7 8d8dbcfeffff 2b45e8 53 50 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8bc7                 | mov                 eax, edi
            //   8d8dbcfeffff         | lea                 ecx, [ebp - 0x144]
            //   2b45e8               | sub                 eax, dword ptr [ebp - 0x18]
            //   53                   | push                ebx
            //   50                   | push                eax

        $sequence_1 = { e8???????? 50 c645fc0d e8???????? 83c410 8d8d50ffffff e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   50                   | push                eax
            //   c645fc0d             | mov                 byte ptr [ebp - 4], 0xd
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8d8d50ffffff         | lea                 ecx, [ebp - 0xb0]
            //   e8????????           |                     

        $sequence_2 = { e9???????? 8d4701 50 e8???????? 8bf0 33c0 57 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d4701               | lea                 eax, [edi + 1]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   33c0                 | xor                 eax, eax
            //   57                   | push                edi

        $sequence_3 = { 8b4704 83c40c 8bde 3bf0 7418 6a6c 8bf8 }
            // n = 7, score = 100
            //   8b4704               | mov                 eax, dword ptr [edi + 4]
            //   83c40c               | add                 esp, 0xc
            //   8bde                 | mov                 ebx, esi
            //   3bf0                 | cmp                 esi, eax
            //   7418                 | je                  0x1a
            //   6a6c                 | push                0x6c
            //   8bf8                 | mov                 edi, eax

        $sequence_4 = { 50 e8???????? c745ec03000000 8b4d18 8d45f3 50 8d45d4 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   c745ec03000000       | mov                 dword ptr [ebp - 0x14], 3
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   8d45f3               | lea                 eax, [ebp - 0xd]
            //   50                   | push                eax
            //   8d45d4               | lea                 eax, [ebp - 0x2c]

        $sequence_5 = { 66394604 7505 8d4606 eb3f 6a5c 5a 83ff03 }
            // n = 7, score = 100
            //   66394604             | cmp                 word ptr [esi + 4], ax
            //   7505                 | jne                 7
            //   8d4606               | lea                 eax, [esi + 6]
            //   eb3f                 | jmp                 0x41
            //   6a5c                 | push                0x5c
            //   5a                   | pop                 edx
            //   83ff03               | cmp                 edi, 3

        $sequence_6 = { 6a40 ff7508 8b7850 8b7054 8b5858 8945fc 8d45b0 }
            // n = 7, score = 100
            //   6a40                 | push                0x40
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8b7850               | mov                 edi, dword ptr [eax + 0x50]
            //   8b7054               | mov                 esi, dword ptr [eax + 0x54]
            //   8b5858               | mov                 ebx, dword ptr [eax + 0x58]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8d45b0               | lea                 eax, [ebp - 0x50]

        $sequence_7 = { 8945e0 8d0c38 8d4118 895110 894508 895114 e8???????? }
            // n = 7, score = 100
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8d0c38               | lea                 ecx, [eax + edi]
            //   8d4118               | lea                 eax, [ecx + 0x18]
            //   895110               | mov                 dword ptr [ecx + 0x10], edx
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   895114               | mov                 dword ptr [ecx + 0x14], edx
            //   e8????????           |                     

        $sequence_8 = { 84c0 75f9 ff7510 2bce 51 52 ff7508 }
            // n = 7, score = 100
            //   84c0                 | test                al, al
            //   75f9                 | jne                 0xfffffffb
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   2bce                 | sub                 ecx, esi
            //   51                   | push                ecx
            //   52                   | push                edx
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_9 = { 8b5508 56 8bf1 8b02 894610 8b4224 894614 }
            // n = 7, score = 100
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   894610               | mov                 dword ptr [esi + 0x10], eax
            //   8b4224               | mov                 eax, dword ptr [edx + 0x24]
            //   894614               | mov                 dword ptr [esi + 0x14], eax

    condition:
        7 of them and filesize < 1021952
}