rule win_rhino_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rhino."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rhino"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 895df0 57 895e10 8bfa c7461407000000 668906 8b4d08 }
            // n = 7, score = 400
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx
            //   57                   | push                edi
            //   895e10               | mov                 dword ptr [esi + 0x10], ebx
            //   8bfa                 | mov                 edi, edx
            //   c7461407000000       | mov                 dword ptr [esi + 0x14], 7
            //   668906               | mov                 word ptr [esi], ax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_1 = { 0316 80790500 8955e0 7419 8b37 8d45ac 50 }
            // n = 7, score = 400
            //   0316                 | add                 edx, dword ptr [esi]
            //   80790500             | cmp                 byte ptr [ecx + 5], 0
            //   8955e0               | mov                 dword ptr [ebp - 0x20], edx
            //   7419                 | je                  0x1b
            //   8b37                 | mov                 esi, dword ptr [edi]
            //   8d45ac               | lea                 eax, [ebp - 0x54]
            //   50                   | push                eax

        $sequence_2 = { 8b7d18 8b4d08 8bc6 c1e802 83e603 8b5108 8b4904 }
            // n = 7, score = 400
            //   8b7d18               | mov                 edi, dword ptr [ebp + 0x18]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8bc6                 | mov                 eax, esi
            //   c1e802               | shr                 eax, 2
            //   83e603               | and                 esi, 3
            //   8b5108               | mov                 edx, dword ptr [ecx + 8]
            //   8b4904               | mov                 ecx, dword ptr [ecx + 4]

        $sequence_3 = { ff7510 56 e8???????? 83c414 5e 8be5 5d }
            // n = 7, score = 400
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp

        $sequence_4 = { ff15???????? 2bf0 eb08 ff15???????? 03f0 ff742414 57 }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   2bf0                 | sub                 esi, eax
            //   eb08                 | jmp                 0xa
            //   ff15????????         |                     
            //   03f0                 | add                 esi, eax
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   57                   | push                edi

        $sequence_5 = { c645fc00 8d7514 ff75fc c645f800 ff75f8 83ec0c 8bfc }
            // n = 7, score = 400
            //   c645fc00             | mov                 byte ptr [ebp - 4], 0
            //   8d7514               | lea                 esi, [ebp + 0x14]
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   c645f800             | mov                 byte ptr [ebp - 8], 0
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   83ec0c               | sub                 esp, 0xc
            //   8bfc                 | mov                 edi, esp

        $sequence_6 = { 6a01 8d4508 50 8d45e4 68???????? 50 e8???????? }
            // n = 7, score = 400
            //   6a01                 | push                1
            //   8d4508               | lea                 eax, [ebp + 8]
            //   50                   | push                eax
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_7 = { 3bfe 7512 8b33 8bcb ff5620 50 ff75a8 }
            // n = 7, score = 400
            //   3bfe                 | cmp                 edi, esi
            //   7512                 | jne                 0x14
            //   8b33                 | mov                 esi, dword ptr [ebx]
            //   8bcb                 | mov                 ecx, ebx
            //   ff5620               | call                dword ptr [esi + 0x20]
            //   50                   | push                eax
            //   ff75a8               | push                dword ptr [ebp - 0x58]

        $sequence_8 = { 8b442424 894804 83c010 897714 89442424 3beb 0f8226fdffff }
            // n = 7, score = 400
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   83c010               | add                 eax, 0x10
            //   897714               | mov                 dword ptr [edi + 0x14], esi
            //   89442424             | mov                 dword ptr [esp + 0x24], eax
            //   3beb                 | cmp                 ebp, ebx
            //   0f8226fdffff         | jb                  0xfffffd2c

        $sequence_9 = { 8bc7 c1c802 33c8 03d9 837c241000 895c2414 743c }
            // n = 7, score = 400
            //   8bc7                 | mov                 eax, edi
            //   c1c802               | ror                 eax, 2
            //   33c8                 | xor                 ecx, eax
            //   03d9                 | add                 ebx, ecx
            //   837c241000           | cmp                 dword ptr [esp + 0x10], 0
            //   895c2414             | mov                 dword ptr [esp + 0x14], ebx
            //   743c                 | je                  0x3e

    condition:
        7 of them and filesize < 1288192
}