rule win_rhttpctrl_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rhttpctrl."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rhttpctrl"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { d1fe 6a55 ff34f5c0d54100 ff7508 e8???????? 83c40c 85c0 }
            // n = 7, score = 100
            //   d1fe                 | sar                 esi, 1
            //   6a55                 | push                0x55
            //   ff34f5c0d54100       | push                dword ptr [esi*8 + 0x41d5c0]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax

        $sequence_1 = { c645f401 ff15???????? 6a00 6a00 }
            // n = 4, score = 100
            //   c645f401             | mov                 byte ptr [ebp - 0xc], 1
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_2 = { c78424d901000000000000 8d8424e0010000 660fd68424d1010000 0f118424c1010000 6800040000 50 66c78424e50100000000 }
            // n = 7, score = 100
            //   c78424d901000000000000     | mov    dword ptr [esp + 0x1d9], 0
            //   8d8424e0010000       | lea                 eax, [esp + 0x1e0]
            //   660fd68424d1010000     | movq    qword ptr [esp + 0x1d1], xmm0
            //   0f118424c1010000     | movups              xmmword ptr [esp + 0x1c1], xmm0
            //   6800040000           | push                0x400
            //   50                   | push                eax
            //   66c78424e50100000000     | mov    word ptr [esp + 0x1e5], 0

        $sequence_3 = { 6a2b 68???????? 57 e8???????? 83c40c 8d85f8feffff 8d772b }
            // n = 7, score = 100
            //   6a2b                 | push                0x2b
            //   68????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   8d772b               | lea                 esi, [edi + 0x2b]

        $sequence_4 = { ff248545924000 8bce e8???????? eb45 834e28ff 895e24 }
            // n = 6, score = 100
            //   ff248545924000       | jmp                 dword ptr [eax*4 + 0x409245]
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   eb45                 | jmp                 0x47
            //   834e28ff             | or                  dword ptr [esi + 0x28], 0xffffffff
            //   895e24               | mov                 dword ptr [esi + 0x24], ebx

        $sequence_5 = { 68???????? e8???????? 83c408 895f08 837f1400 c7471001000000 }
            // n = 6, score = 100
            //   68????????           |                     
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   895f08               | mov                 dword ptr [edi + 8], ebx
            //   837f1400             | cmp                 dword ptr [edi + 0x14], 0
            //   c7471001000000       | mov                 dword ptr [edi + 0x10], 1

        $sequence_6 = { b824280000 e8???????? a1???????? 33c5 8945f0 53 56 }
            // n = 7, score = 100
            //   b824280000           | mov                 eax, 0x2824
            //   e8????????           |                     
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_7 = { ffb5d8d7ffff ffd6 ffb5d4d7ffff ffd6 8d8ddcd7ffff }
            // n = 5, score = 100
            //   ffb5d8d7ffff         | push                dword ptr [ebp - 0x2828]
            //   ffd6                 | call                esi
            //   ffb5d4d7ffff         | push                dword ptr [ebp - 0x282c]
            //   ffd6                 | call                esi
            //   8d8ddcd7ffff         | lea                 ecx, [ebp - 0x2824]

        $sequence_8 = { 33d2 8b08 85c9 7407 }
            // n = 4, score = 100
            //   33d2                 | xor                 edx, edx
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   85c9                 | test                ecx, ecx
            //   7407                 | je                  9

        $sequence_9 = { ffb5e4d7ffff ffb5e0d7ffff 50 ff15???????? 8bc8 898dd8d7ffff 85c9 }
            // n = 7, score = 100
            //   ffb5e4d7ffff         | push                dword ptr [ebp - 0x281c]
            //   ffb5e0d7ffff         | push                dword ptr [ebp - 0x2820]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bc8                 | mov                 ecx, eax
            //   898dd8d7ffff         | mov                 dword ptr [ebp - 0x2828], ecx
            //   85c9                 | test                ecx, ecx

    condition:
        7 of them and filesize < 339968
}