rule win_rikamanu_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rikamanu."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rikamanu"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 6a14 ff15???????? a801 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   6a14                 | push                0x14
            //   ff15????????         |                     
            //   a801                 | test                al, 1

        $sequence_1 = { 50 ff15???????? 8b35???????? 3d80969800 }
            // n = 4, score = 200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   3d80969800           | cmp                 eax, 0x989680

        $sequence_2 = { 33c0 663bcb 0f95c0 a3???????? }
            // n = 4, score = 100
            //   33c0                 | xor                 eax, eax
            //   663bcb               | cmp                 cx, bx
            //   0f95c0               | setne               al
            //   a3????????           |                     

        $sequence_3 = { 80c120 888820ad4000 eb1f 83f861 7213 83f87a 770e }
            // n = 7, score = 100
            //   80c120               | add                 cl, 0x20
            //   888820ad4000         | mov                 byte ptr [eax + 0x40ad20], cl
            //   eb1f                 | jmp                 0x21
            //   83f861               | cmp                 eax, 0x61
            //   7213                 | jb                  0x15
            //   83f87a               | cmp                 eax, 0x7a
            //   770e                 | ja                  0x10

        $sequence_4 = { 59 50 8d85e8faffff 50 ff35???????? }
            // n = 5, score = 100
            //   59                   | pop                 ecx
            //   50                   | push                eax
            //   8d85e8faffff         | lea                 eax, [ebp - 0x518]
            //   50                   | push                eax
            //   ff35????????         |                     

        $sequence_5 = { 85f6 7419 0fb6da f683a1a7400004 }
            // n = 4, score = 100
            //   85f6                 | test                esi, esi
            //   7419                 | je                  0x1b
            //   0fb6da               | movzx               ebx, dl
            //   f683a1a7400004       | test                byte ptr [ebx + 0x40a7a1], 4

        $sequence_6 = { c3 0fb6442404 8a4c240c 8488a1a74000 751c 837c240800 }
            // n = 6, score = 100
            //   c3                   | ret                 
            //   0fb6442404           | movzx               eax, byte ptr [esp + 4]
            //   8a4c240c             | mov                 cl, byte ptr [esp + 0xc]
            //   8488a1a74000         | test                byte ptr [eax + 0x40a7a1], cl
            //   751c                 | jne                 0x1e
            //   837c240800           | cmp                 dword ptr [esp + 8], 0

        $sequence_7 = { 8d8de4fdffff 51 e8???????? 8b8de4fdffff 8b35???????? 8d95ccfdffff }
            // n = 6, score = 100
            //   8d8de4fdffff         | lea                 ecx, [ebp - 0x21c]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b8de4fdffff         | mov                 ecx, dword ptr [ebp - 0x21c]
            //   8b35????????         |                     
            //   8d95ccfdffff         | lea                 edx, [ebp - 0x234]

        $sequence_8 = { 8d74242c b8???????? 8a10 8aca 3a16 751c 3acb }
            // n = 7, score = 100
            //   8d74242c             | lea                 esi, [esp + 0x2c]
            //   b8????????           |                     
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   8aca                 | mov                 cl, dl
            //   3a16                 | cmp                 dl, byte ptr [esi]
            //   751c                 | jne                 0x1e
            //   3acb                 | cmp                 cl, bl

        $sequence_9 = { 8b7d0c 85db 0f84b2000000 85ff 0f84aa000000 8d85a4fdffff }
            // n = 6, score = 100
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   85db                 | test                ebx, ebx
            //   0f84b2000000         | je                  0xb8
            //   85ff                 | test                edi, edi
            //   0f84aa000000         | je                  0xb0
            //   8d85a4fdffff         | lea                 eax, [ebp - 0x25c]

        $sequence_10 = { 8bc3 8bcb c1f805 83e11f 8b0485e0b84000 }
            // n = 5, score = 100
            //   8bc3                 | mov                 eax, ebx
            //   8bcb                 | mov                 ecx, ebx
            //   c1f805               | sar                 eax, 5
            //   83e11f               | and                 ecx, 0x1f
            //   8b0485e0b84000       | mov                 eax, dword ptr [eax*4 + 0x40b8e0]

        $sequence_11 = { 85c0 7457 68???????? 56 ffd5 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   7457                 | je                  0x59
            //   68????????           |                     
            //   56                   | push                esi
            //   ffd5                 | call                ebp

        $sequence_12 = { 6810270000 ff15???????? 8b85e4fdffff 8d8dccfdffff 51 8d9588fdffff 52 }
            // n = 7, score = 100
            //   6810270000           | push                0x2710
            //   ff15????????         |                     
            //   8b85e4fdffff         | mov                 eax, dword ptr [ebp - 0x21c]
            //   8d8dccfdffff         | lea                 ecx, [ebp - 0x234]
            //   51                   | push                ecx
            //   8d9588fdffff         | lea                 edx, [ebp - 0x278]
            //   52                   | push                edx

        $sequence_13 = { 5d c20800 8b55e8 6a00 }
            // n = 4, score = 100
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   6a00                 | push                0

        $sequence_14 = { 888808972400 40 ebe6 ff35???????? ff15???????? 85c0 }
            // n = 6, score = 100
            //   888808972400         | mov                 byte ptr [eax + 0x249708], cl
            //   40                   | inc                 eax
            //   ebe6                 | jmp                 0xffffffe8
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_15 = { 8dbc2430010000 83c9ff f2ae f7d1 2bf9 8bf7 }
            // n = 6, score = 100
            //   8dbc2430010000       | lea                 edi, [esp + 0x130]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   8bf7                 | mov                 esi, edi

        $sequence_16 = { ffd3 55 55 8d4c2444 55 }
            // n = 5, score = 100
            //   ffd3                 | call                ebx
            //   55                   | push                ebp
            //   55                   | push                ebp
            //   8d4c2444             | lea                 ecx, [esp + 0x44]
            //   55                   | push                ebp

        $sequence_17 = { ff15???????? a3???????? 3bc3 7530 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   a3????????           |                     
            //   3bc3                 | cmp                 eax, ebx
            //   7530                 | jne                 0x32

        $sequence_18 = { 8b35???????? 68???????? ffd6 8be8 83fdff 750b }
            // n = 6, score = 100
            //   8b35????????         |                     
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   8be8                 | mov                 ebp, eax
            //   83fdff               | cmp                 ebp, -1
            //   750b                 | jne                 0xd

        $sequence_19 = { 6a00 68???????? 8b442418 6a03 }
            // n = 4, score = 100
            //   6a00                 | push                0
            //   68????????           |                     
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   6a03                 | push                3

        $sequence_20 = { 0fb6da f683a1a7400004 7406 8816 }
            // n = 4, score = 100
            //   0fb6da               | movzx               ebx, dl
            //   f683a1a7400004       | test                byte ptr [ebx + 0x40a7a1], 4
            //   7406                 | je                  8
            //   8816                 | mov                 byte ptr [esi], dl

        $sequence_21 = { 7373 8bc8 8bf0 c1f905 83e61f 8d3c8de0b84000 c1e603 }
            // n = 7, score = 100
            //   7373                 | jae                 0x75
            //   8bc8                 | mov                 ecx, eax
            //   8bf0                 | mov                 esi, eax
            //   c1f905               | sar                 ecx, 5
            //   83e61f               | and                 esi, 0x1f
            //   8d3c8de0b84000       | lea                 edi, [ecx*4 + 0x40b8e0]
            //   c1e603               | shl                 esi, 3

        $sequence_22 = { 8a8160204100 8802 5b 5d c3 }
            // n = 5, score = 100
            //   8a8160204100         | mov                 al, byte ptr [ecx + 0x412060]
            //   8802                 | mov                 byte ptr [edx], al
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_23 = { a1???????? 0f45c6 a3???????? ebcf 83f802 }
            // n = 5, score = 100
            //   a1????????           |                     
            //   0f45c6               | cmovne              eax, esi
            //   a3????????           |                     
            //   ebcf                 | jmp                 0xffffffd1
            //   83f802               | cmp                 eax, 2

        $sequence_24 = { 50 53 6800130000 ff15???????? 5b }
            // n = 5, score = 100
            //   50                   | push                eax
            //   53                   | push                ebx
            //   6800130000           | push                0x1300
            //   ff15????????         |                     
            //   5b                   | pop                 ebx

        $sequence_25 = { f682a1a7400004 740c ff01 85f6 }
            // n = 4, score = 100
            //   f682a1a7400004       | test                byte ptr [edx + 0x40a7a1], 4
            //   740c                 | je                  0xe
            //   ff01                 | inc                 dword ptr [ecx]
            //   85f6                 | test                esi, esi

        $sequence_26 = { 52 6a01 53 53 e8???????? 8b95e0fdffff }
            // n = 6, score = 100
            //   52                   | push                edx
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8b95e0fdffff         | mov                 edx, dword ptr [ebp - 0x220]

        $sequence_27 = { 7410 8088????????20 8a9405ecfcffff ebe3 80a020ad400000 40 }
            // n = 6, score = 100
            //   7410                 | je                  0x12
            //   8088????????20       |                     
            //   8a9405ecfcffff       | mov                 dl, byte ptr [ebp + eax - 0x314]
            //   ebe3                 | jmp                 0xffffffe5
            //   80a020ad400000       | and                 byte ptr [eax + 0x40ad20], 0
            //   40                   | inc                 eax

        $sequence_28 = { 68???????? e8???????? 8b3d???????? 59 59 85c0 751b }
            // n = 7, score = 100
            //   68????????           |                     
            //   e8????????           |                     
            //   8b3d????????         |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   751b                 | jne                 0x1d

        $sequence_29 = { 8d8914982400 5a 668b31 668930 }
            // n = 4, score = 100
            //   8d8914982400         | lea                 ecx, [ecx + 0x249814]
            //   5a                   | pop                 edx
            //   668b31               | mov                 si, word ptr [ecx]
            //   668930               | mov                 word ptr [eax], si

    condition:
        7 of them and filesize < 212992
}