rule win_ripper_atm_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ripper_atm."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ripper_atm"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 ff15???????? 85c0 7413 83671000 c747140f000000 c60700 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7413                 | je                  0x15
            //   83671000             | and                 dword ptr [edi + 0x10], 0
            //   c747140f000000       | mov                 dword ptr [edi + 0x14], 0xf
            //   c60700               | mov                 byte ptr [edi], 0

        $sequence_1 = { 89742414 83cbff 395d08 7507 33c0 e9???????? 8b4620 }
            // n = 7, score = 100
            //   89742414             | mov                 dword ptr [esp + 0x14], esi
            //   83cbff               | or                  ebx, 0xffffffff
            //   395d08               | cmp                 dword ptr [ebp + 8], ebx
            //   7507                 | jne                 9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]

        $sequence_2 = { 7485 80f90d 7480 40 8907 e9???????? 8b4760 }
            // n = 7, score = 100
            //   7485                 | je                  0xffffff87
            //   80f90d               | cmp                 cl, 0xd
            //   7480                 | je                  0xffffff82
            //   40                   | inc                 eax
            //   8907                 | mov                 dword ptr [edi], eax
            //   e9????????           |                     
            //   8b4760               | mov                 eax, dword ptr [edi + 0x60]

        $sequence_3 = { 6824010000 b8???????? e8???????? 8d4508 33f6 50 ba???????? }
            // n = 7, score = 100
            //   6824010000           | push                0x124
            //   b8????????           |                     
            //   e8????????           |                     
            //   8d4508               | lea                 eax, [ebp + 8]
            //   33f6                 | xor                 esi, esi
            //   50                   | push                eax
            //   ba????????           |                     

        $sequence_4 = { 57 8bfe 8955f8 894dfc 897dec 3bf0 7445 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8bfe                 | mov                 edi, esi
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   897dec               | mov                 dword ptr [ebp - 0x14], edi
            //   3bf0                 | cmp                 esi, eax
            //   7445                 | je                  0x47

        $sequence_5 = { 8d45ec 50 8d4de0 c745ec00000400 }
            // n = 4, score = 100
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   c745ec00000400       | mov                 dword ptr [ebp - 0x14], 0x40000

        $sequence_6 = { 8bf2 897518 8955f8 3bd7 741c 3b4514 }
            // n = 6, score = 100
            //   8bf2                 | mov                 esi, edx
            //   897518               | mov                 dword ptr [ebp + 0x18], esi
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   3bd7                 | cmp                 edx, edi
            //   741c                 | je                  0x1e
            //   3b4514               | cmp                 eax, dword ptr [ebp + 0x14]

        $sequence_7 = { 8b148df0974400 83e31f c1e306 894df4 8a441a04 895ddc a801 }
            // n = 7, score = 100
            //   8b148df0974400       | mov                 edx, dword ptr [ecx*4 + 0x4497f0]
            //   83e31f               | and                 ebx, 0x1f
            //   c1e306               | shl                 ebx, 6
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   8a441a04             | mov                 al, byte ptr [edx + ebx + 4]
            //   895ddc               | mov                 dword ptr [ebp - 0x24], ebx
            //   a801                 | test                al, 1

        $sequence_8 = { 334ad8 3342dc 334a28 33422c 330a 334204 894cf428 }
            // n = 7, score = 100
            //   334ad8               | xor                 ecx, dword ptr [edx - 0x28]
            //   3342dc               | xor                 eax, dword ptr [edx - 0x24]
            //   334a28               | xor                 ecx, dword ptr [edx + 0x28]
            //   33422c               | xor                 eax, dword ptr [edx + 0x2c]
            //   330a                 | xor                 ecx, dword ptr [edx]
            //   334204               | xor                 eax, dword ptr [edx + 4]
            //   894cf428             | mov                 dword ptr [esp + esi*8 + 0x28], ecx

        $sequence_9 = { 56 33f6 ffb6b0784300 ff15???????? 8986b0784300 83c604 83fe28 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   33f6                 | xor                 esi, esi
            //   ffb6b0784300         | push                dword ptr [esi + 0x4378b0]
            //   ff15????????         |                     
            //   8986b0784300         | mov                 dword ptr [esi + 0x4378b0], eax
            //   83c604               | add                 esi, 4
            //   83fe28               | cmp                 esi, 0x28

    condition:
        7 of them and filesize < 724992
}