rule win_rms_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rms"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb13 8b45f8 8b507c 8b450c 8b00 8b4048 e8???????? }
            // n = 7, score = 200
            //   eb13                 | jmp                 0x15
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b507c               | mov                 edx, dword ptr [eax + 0x7c]
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b4048               | mov                 eax, dword ptr [eax + 0x48]
            //   e8????????           |                     

        $sequence_1 = { f7da 8d45cc e8???????? 8b45f8 e8???????? 50 e8???????? }
            // n = 7, score = 200
            //   f7da                 | neg                 edx
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   e8????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_2 = { eb03 c60300 5f 5e 5b 8be5 5d }
            // n = 7, score = 200
            //   eb03                 | jmp                 5
            //   c60300               | mov                 byte ptr [ebx], 0
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp

        $sequence_3 = { e8???????? e9???????? 8b4508 e8???????? 50 56 8b45fc }
            // n = 7, score = 200
            //   e8????????           |                     
            //   e9????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   e8????????           |                     
            //   50                   | push                eax
            //   56                   | push                esi
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_4 = { e8???????? ffb558ffffff 8d8560ffffff ba03000000 e8???????? 8b8560ffffff e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   ffb558ffffff         | push                dword ptr [ebp - 0xa8]
            //   8d8560ffffff         | lea                 eax, [ebp - 0xa0]
            //   ba03000000           | mov                 edx, 3
            //   e8????????           |                     
            //   8b8560ffffff         | mov                 eax, dword ptr [ebp - 0xa0]
            //   e8????????           |                     

        $sequence_5 = { a1???????? e8???????? 43 4e 0f8534fdffff 33c0 5a }
            // n = 7, score = 200
            //   a1????????           |                     
            //   e8????????           |                     
            //   43                   | inc                 ebx
            //   4e                   | dec                 esi
            //   0f8534fdffff         | jne                 0xfffffd3a
            //   33c0                 | xor                 eax, eax
            //   5a                   | pop                 edx

        $sequence_6 = { eb74 6a00 6a00 6a00 8b45ec 50 6a01 }
            // n = 7, score = 200
            //   eb74                 | jmp                 0x76
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   50                   | push                eax
            //   6a01                 | push                1

        $sequence_7 = { f6c310 740b 8bc6 e8???????? 84c0 7504 33c0 }
            // n = 7, score = 200
            //   f6c310               | test                bl, 0x10
            //   740b                 | je                  0xd
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { e8???????? ffb55cffffff 68???????? 8d8558ffffff e8???????? ffb558ffffff 8d8560ffffff }
            // n = 7, score = 200
            //   e8????????           |                     
            //   ffb55cffffff         | push                dword ptr [ebp - 0xa4]
            //   68????????           |                     
            //   8d8558ffffff         | lea                 eax, [ebp - 0xa8]
            //   e8????????           |                     
            //   ffb558ffffff         | push                dword ptr [ebp - 0xa8]
            //   8d8560ffffff         | lea                 eax, [ebp - 0xa0]

        $sequence_9 = { e8???????? 8b45fc e8???????? ff750c ff7508 8d55d0 8b45fc }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d55d0               | lea                 edx, [ebp - 0x30]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

    condition:
        7 of them and filesize < 35323904
}