rule win_roadsweep_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.roadsweep."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.roadsweep"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c1f902 0fb691b0914000 88141e 8b18 46 }
            // n = 5, score = 100
            //   c1f902               | sar                 ecx, 2
            //   0fb691b0914000       | movzx               edx, byte ptr [ecx + 0x4091b0]
            //   88141e               | mov                 byte ptr [esi + ebx], dl
            //   8b18                 | mov                 ebx, dword ptr [eax]
            //   46                   | inc                 esi

        $sequence_1 = { 8944240c 8b4514 89442404 ff521c 8b75c8 31c9 }
            // n = 6, score = 100
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   ff521c               | call                dword ptr [edx + 0x1c]
            //   8b75c8               | mov                 esi, dword ptr [ebp - 0x38]
            //   31c9                 | xor                 ecx, ecx

        $sequence_2 = { 85c0 740c 31c0 8b5df8 8b75fc 89ec 5d }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   740c                 | je                  0xe
            //   31c0                 | xor                 eax, eax
            //   8b5df8               | mov                 ebx, dword ptr [ebp - 8]
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   89ec                 | mov                 esp, ebp
            //   5d                   | pop                 ebp

        $sequence_3 = { 7403 83cb01 84c9 7409 8b4d18 8b39 01f8 }
            // n = 7, score = 100
            //   7403                 | je                  5
            //   83cb01               | or                  ebx, 1
            //   84c9                 | test                cl, cl
            //   7409                 | je                  0xb
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   8b39                 | mov                 edi, dword ptr [ecx]
            //   01f8                 | add                 eax, edi

        $sequence_4 = { 5b 5e 5f 5d c3 85c0 750d }
            // n = 7, score = 100
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   85c0                 | test                eax, eax
            //   750d                 | jne                 0xf

        $sequence_5 = { 89e5 fc 83ec08 b90e000000 891c24 8b5d08 897c2404 }
            // n = 7, score = 100
            //   89e5                 | mov                 ebp, esp
            //   fc                   | cld                 
            //   83ec08               | sub                 esp, 8
            //   b90e000000           | mov                 ecx, 0xe
            //   891c24               | mov                 dword ptr [esp], ebx
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   897c2404             | mov                 dword ptr [esp + 4], edi

        $sequence_6 = { 8b9540ffffff 891424 e8???????? c745a001000000 e8???????? 83c518 837da001 }
            // n = 7, score = 100
            //   8b9540ffffff         | mov                 edx, dword ptr [ebp - 0xc0]
            //   891424               | mov                 dword ptr [esp], edx
            //   e8????????           |                     
            //   c745a001000000       | mov                 dword ptr [ebp - 0x60], 1
            //   e8????????           |                     
            //   83c518               | add                 ebp, 0x18
            //   837da001             | cmp                 dword ptr [ebp - 0x60], 1

        $sequence_7 = { c744240400000000 83ee64 891c24 e8???????? }
            // n = 4, score = 100
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   83ee64               | sub                 esi, 0x64
            //   891c24               | mov                 dword ptr [esp], ebx
            //   e8????????           |                     

        $sequence_8 = { c68565fdffff23 c68566fdffff5b c68567fdffff55 c68568fdffff7f c68569fdffff36 c6856afdffff7e c6856bfdffff76 }
            // n = 7, score = 100
            //   c68565fdffff23       | mov                 byte ptr [ebp - 0x29b], 0x23
            //   c68566fdffff5b       | mov                 byte ptr [ebp - 0x29a], 0x5b
            //   c68567fdffff55       | mov                 byte ptr [ebp - 0x299], 0x55
            //   c68568fdffff7f       | mov                 byte ptr [ebp - 0x298], 0x7f
            //   c68569fdffff36       | mov                 byte ptr [ebp - 0x297], 0x36
            //   c6856afdffff7e       | mov                 byte ptr [ebp - 0x296], 0x7e
            //   c6856bfdffff76       | mov                 byte ptr [ebp - 0x295], 0x76

        $sequence_9 = { 89542408 891c24 e8???????? 893424 e8???????? 8b4510 }
            // n = 6, score = 100
            //   89542408             | mov                 dword ptr [esp + 8], edx
            //   891c24               | mov                 dword ptr [esp], ebx
            //   e8????????           |                     
            //   893424               | mov                 dword ptr [esp], esi
            //   e8????????           |                     
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

    condition:
        7 of them and filesize < 160768
}