rule win_robinhood_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.robinhood"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d2de08b5d00 8d74cd00 8b3e 01df 8b5a04 8b7604 893a }
            // n = 7, score = 100
            //   8d2de08b5d00         | lea                 ebp, [0x5d8be0]
            //   8d74cd00             | lea                 esi, [ebp + ecx*8]
            //   8b3e                 | mov                 edi, dword ptr [esi]
            //   01df                 | add                 edi, ebx
            //   8b5a04               | mov                 ebx, dword ptr [edx + 4]
            //   8b7604               | mov                 esi, dword ptr [esi + 4]
            //   893a                 | mov                 dword ptr [edx], edi

        $sequence_1 = { 8d05c07a4f00 890424 8d05c0675300 89442404 e8???????? 0f0b 8d05c07a4f00 }
            // n = 7, score = 100
            //   8d05c07a4f00         | lea                 eax, [0x4f7ac0]
            //   890424               | mov                 dword ptr [esp], eax
            //   8d05c0675300         | lea                 eax, [0x5367c0]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   e8????????           |                     
            //   0f0b                 | ud2                 
            //   8d05c07a4f00         | lea                 eax, [0x4f7ac0]

        $sequence_2 = { 895110 8d1dfcf35f00 891c24 c744240401000000 e8???????? 8b4c2420 8b5114 }
            // n = 7, score = 100
            //   895110               | mov                 dword ptr [ecx + 0x10], edx
            //   8d1dfcf35f00         | lea                 ebx, [0x5ff3fc]
            //   891c24               | mov                 dword ptr [esp], ebx
            //   c744240401000000     | mov                 dword ptr [esp + 4], 1
            //   e8????????           |                     
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   8b5114               | mov                 edx, dword ptr [ecx + 0x14]

        $sequence_3 = { c744240800000000 e8???????? 0fb644240c 84c0 74be 8d05e0f55f00 890424 }
            // n = 7, score = 100
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   e8????????           |                     
            //   0fb644240c           | movzx               eax, byte ptr [esp + 0xc]
            //   84c0                 | test                al, al
            //   74be                 | je                  0xffffffc0
            //   8d05e0f55f00         | lea                 eax, [0x5ff5e0]
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_4 = { 8b4110 8b8c24a0020000 890c24 ffd0 8b442404 8b4c2408 8d942418020000 }
            // n = 7, score = 100
            //   8b4110               | mov                 eax, dword ptr [ecx + 0x10]
            //   8b8c24a0020000       | mov                 ecx, dword ptr [esp + 0x2a0]
            //   890c24               | mov                 dword ptr [esp], ecx
            //   ffd0                 | call                eax
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   8d942418020000       | lea                 edx, [esp + 0x218]

        $sequence_5 = { c744240800000000 c744240c0a000000 c644241000 8d0d8d595100 894c2414 c744241811000000 e8???????? }
            // n = 7, score = 100
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   c744240c0a000000     | mov                 dword ptr [esp + 0xc], 0xa
            //   c644241000           | mov                 byte ptr [esp + 0x10], 0
            //   8d0d8d595100         | lea                 ecx, [0x51598d]
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   c744241811000000     | mov                 dword ptr [esp + 0x18], 0x11
            //   e8????????           |                     

        $sequence_6 = { 8b05???????? 89442424 8d0d60824f00 890c24 8b542420 89542404 8d1d94345100 }
            // n = 7, score = 100
            //   8b05????????         |                     
            //   89442424             | mov                 dword ptr [esp + 0x24], eax
            //   8d0d60824f00         | lea                 ecx, [0x4f8260]
            //   890c24               | mov                 dword ptr [esp], ecx
            //   8b542420             | mov                 edx, dword ptr [esp + 0x20]
            //   89542404             | mov                 dword ptr [esp + 4], edx
            //   8d1d94345100         | lea                 ebx, [0x513494]

        $sequence_7 = { ebab e8???????? 8d05b0ea5100 890424 c744240436000000 e8???????? e8???????? }
            // n = 7, score = 100
            //   ebab                 | jmp                 0xffffffad
            //   e8????????           |                     
            //   8d05b0ea5100         | lea                 eax, [0x51eab0]
            //   890424               | mov                 dword ptr [esp], eax
            //   c744240436000000     | mov                 dword ptr [esp + 4], 0x36
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_8 = { 890424 8d442414 89442404 e8???????? 8d0540f55f00 890424 e8???????? }
            // n = 7, score = 100
            //   890424               | mov                 dword ptr [esp], eax
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   e8????????           |                     
            //   8d0540f55f00         | lea                 eax, [0x5ff540]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_9 = { 8d4808 31d2 ebb2 8d0500fb5f00 8944241c c644242000 83c40c }
            // n = 7, score = 100
            //   8d4808               | lea                 ecx, [eax + 8]
            //   31d2                 | xor                 edx, edx
            //   ebb2                 | jmp                 0xffffffb4
            //   8d0500fb5f00         | lea                 eax, [0x5ffb00]
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   c644242000           | mov                 byte ptr [esp + 0x20], 0
            //   83c40c               | add                 esp, 0xc

    condition:
        7 of them and filesize < 5955584
}