rule win_rockloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rockloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rockloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { dd5ddc 9b dbe3 dd45dc db5df8 8b55f8 }
            // n = 6, score = 300
            //   dd5ddc               | fstp                qword ptr [ebp - 0x24]
            //   9b                   | wait                
            //   dbe3                 | fninit              
            //   dd45dc               | fld                 qword ptr [ebp - 0x24]
            //   db5df8               | fistp               dword ptr [ebp - 8]
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_1 = { 40 8a0c30 3acb 75f3 8a0c30 3acb 7413 }
            // n = 7, score = 300
            //   40                   | inc                 eax
            //   8a0c30               | mov                 cl, byte ptr [eax + esi]
            //   3acb                 | cmp                 cl, bl
            //   75f3                 | jne                 0xfffffff5
            //   8a0c30               | mov                 cl, byte ptr [eax + esi]
            //   3acb                 | cmp                 cl, bl
            //   7413                 | je                  0x15

        $sequence_2 = { 7515 85c0 7505 c60632 }
            // n = 4, score = 300
            //   7515                 | jne                 0x17
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   c60632               | mov                 byte ptr [esi], 0x32

        $sequence_3 = { 48 0f84ef000000 48 7407 880e }
            // n = 5, score = 300
            //   48                   | dec                 eax
            //   0f84ef000000         | je                  0xf5
            //   48                   | dec                 eax
            //   7407                 | je                  9
            //   880e                 | mov                 byte ptr [esi], cl

        $sequence_4 = { 8d85a0f7ffff 50 56 c745ece8030000 }
            // n = 4, score = 300
            //   8d85a0f7ffff         | lea                 eax, [ebp - 0x860]
            //   50                   | push                eax
            //   56                   | push                esi
            //   c745ece8030000       | mov                 dword ptr [ebp - 0x14], 0x3e8

        $sequence_5 = { 83e915 741f 83e93a 7415 50 68???????? 56 }
            // n = 7, score = 300
            //   83e915               | sub                 ecx, 0x15
            //   741f                 | je                  0x21
            //   83e93a               | sub                 ecx, 0x3a
            //   7415                 | je                  0x17
            //   50                   | push                eax
            //   68????????           |                     
            //   56                   | push                esi

        $sequence_6 = { 7c0e 80f939 7f09 0fbec9 8d44c1d0 eb24 }
            // n = 6, score = 300
            //   7c0e                 | jl                  0x10
            //   80f939               | cmp                 cl, 0x39
            //   7f09                 | jg                  0xb
            //   0fbec9               | movsx               ecx, cl
            //   8d44c1d0             | lea                 eax, [ecx + eax*8 - 0x30]
            //   eb24                 | jmp                 0x26

        $sequence_7 = { ff36 53 e8???????? ff36 ff15???????? 8b4608 897e04 }
            // n = 7, score = 300
            //   ff36                 | push                dword ptr [esi]
            //   53                   | push                ebx
            //   e8????????           |                     
            //   ff36                 | push                dword ptr [esi]
            //   ff15????????         |                     
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   897e04               | mov                 dword ptr [esi + 4], edi

        $sequence_8 = { db45f8 8a08 dd45ec d8ca }
            // n = 4, score = 300
            //   db45f8               | fild                dword ptr [ebp - 8]
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   dd45ec               | fld                 qword ptr [ebp - 0x14]
            //   d8ca                 | fmul                st(2)

        $sequence_9 = { ff15???????? 8bf3 85db 75b5 5f 5b 5e }
            // n = 7, score = 300
            //   ff15????????         |                     
            //   8bf3                 | mov                 esi, ebx
            //   85db                 | test                ebx, ebx
            //   75b5                 | jne                 0xffffffb7
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 98304
}