rule win_rook_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rook."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rook"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb07 488d1d1a030200 4883a4249800000000 4084f6 }
            // n = 4, score = 100
            //   eb07                 | shl                 eax, 8
            //   488d1d1a030200       | dec                 eax
            //   4883a4249800000000     | shr    eax, 0x18
            //   4084f6               | inc                 ecx

        $sequence_1 = { 488b8da0260000 ff15???????? 4c8b85a0260000 33ff 48897c2438 448bc8 48897c2430 }
            // n = 7, score = 100
            //   488b8da0260000       | dec                 eax
            //   ff15????????         |                     
            //   4c8b85a0260000       | lea                 eax, [0x47415]
            //   33ff                 | dec                 eax
            //   48897c2438           | lea                 edx, [0x47436]
            //   448bc8               | jmp                 0x1636
            //   48897c2430           | cmp                 edx, 2

        $sequence_2 = { 48897de0 e8???????? 85c0 0f8401010000 488d0507f00100 4a8b04e8 }
            // n = 6, score = 100
            //   48897de0             | ja                  0x375
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   0f8401010000         | lea                 edx, [0xffff5c91]
            //   488d0507f00100       | dec                 eax
            //   4a8b04e8             | cwde                

        $sequence_3 = { 483d00100000 7324 0f1f00 486385f0070000 42c6042800 ff85f0070000 }
            // n = 6, score = 100
            //   483d00100000         | dec                 eax
            //   7324                 | sub                 esp, 0x120
            //   0f1f00               | xor                 eax, eax
            //   486385f0070000       | dec                 eax
            //   42c6042800           | mov                 ebp, ecx
            //   ff85f0070000         | inc                 ecx

        $sequence_4 = { 7631 0f1f840000000000 488d0c5b 48c1e104 4803cf f6410c02 7407 }
            // n = 7, score = 100
            //   7631                 | inc                 edx
            //   0f1f840000000000     | movzx               ecx, byte ptr [edx + edx + 0x4c984]
            //   488d0c5b             | shl                 ecx, 8
            //   48c1e104             | or                  ecx, eax
            //   4803cf               | inc                 edx
            //   f6410c02             | movzx               eax, byte ptr [edx + edx + 0x4c986]
            //   7407                 | shl                 ecx, 8

        $sequence_5 = { 48630d???????? 488b05???????? 4c890cc8 488d0d4a640500 }
            // n = 4, score = 100
            //   48630d????????       |                     
            //   488b05????????       |                     
            //   4c890cc8             | inc                 esp
            //   488d0d4a640500       | mov                 eax, dword ptr [eax + 0x14]

        $sequence_6 = { 488d0d13b30000 488b45d8 488908 488d0dc5250200 }
            // n = 4, score = 100
            //   488d0d13b30000       | dec                 eax
            //   488b45d8             | sub                 esp, 0x20
            //   488908               | jmp                 0x19d
            //   488d0dc5250200       | dec                 eax

        $sequence_7 = { 488b0d???????? 4c8d4540 ba08000000 ff15???????? 488bd8 }
            // n = 5, score = 100
            //   488b0d????????       |                     
            //   4c8d4540             | inc                 ebp
            //   ba08000000           | mov                 ebx, edx
            //   ff15????????         |                     
            //   488bd8               | inc                 ecx

        $sequence_8 = { 488d0d63410400 480f440d???????? 48890d???????? 488d0d6d2c0500 }
            // n = 4, score = 100
            //   488d0d63410400       | dec                 eax
            //   480f440d????????     |                     
            //   48890d????????       |                     
            //   488d0d6d2c0500       | sub                 esp, 0x40

        $sequence_9 = { 440f47e8 44896c2448 418d45ff 0fb68c82e2220400 0fb6b482e3220400 8bd9 8bf8 }
            // n = 7, score = 100
            //   440f47e8             | dec                 eax
            //   44896c2448           | and                 dword ptr [esp + 0x98], 0
            //   418d45ff             | dec                 eax
            //   0fb68c82e2220400     | lea                 ebx, [0x2033b]
            //   0fb6b482e3220400     | jmp                 0xd9c
            //   8bd9                 | dec                 eax
            //   8bf8                 | lea                 ebx, [0x2031a]

    condition:
        7 of them and filesize < 843776
}